/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;

public class AssumeRoleWithSAMLRequestMarshaller
implements Marshaller<Request<AssumeRoleWithSAMLRequest>, AssumeRoleWithSAMLRequest> {
    public Request<AssumeRoleWithSAMLRequest> marshall(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        if (assumeRoleWithSAMLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assumeRoleWithSAMLRequest, "STSClient");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleWithSAMLRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)assumeRoleWithSAMLRequest.roleArn()));
        }
        if (assumeRoleWithSAMLRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringUtils.fromString((String)assumeRoleWithSAMLRequest.principalArn()));
        }
        if (assumeRoleWithSAMLRequest.samlAssertion() != null) {
            request.addParameter("SAMLAssertion", StringUtils.fromString((String)assumeRoleWithSAMLRequest.samlAssertion()));
        }
        if (assumeRoleWithSAMLRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)assumeRoleWithSAMLRequest.policy()));
        }
        if (assumeRoleWithSAMLRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)assumeRoleWithSAMLRequest.durationSeconds()));
        }
        return request;
    }
}

