/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, AssumeRoleResponse> {
    private final Credentials credentials;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;

    private AssumeRoleResponse(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.credentials() == null ? 0 : this.credentials().hashCode());
        hashCode = 31 * hashCode + (this.assumedRoleUser() == null ? 0 : this.assumedRoleUser().hashCode());
        hashCode = 31 * hashCode + (this.packedPolicySize() == null ? 0 : this.packedPolicySize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleResponse)) {
            return false;
        }
        AssumeRoleResponse other = (AssumeRoleResponse)((Object)obj);
        if (other.credentials() == null ^ this.credentials() == null) {
            return false;
        }
        if (other.credentials() != null && !other.credentials().equals(this.credentials())) {
            return false;
        }
        if (other.assumedRoleUser() == null ^ this.assumedRoleUser() == null) {
            return false;
        }
        if (other.assumedRoleUser() != null && !other.assumedRoleUser().equals(this.assumedRoleUser())) {
            return false;
        }
        if (other.packedPolicySize() == null ^ this.packedPolicySize() == null) {
            return false;
        }
        return other.packedPolicySize() == null || other.packedPolicySize().equals(this.packedPolicySize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.credentials() != null) {
            sb.append("Credentials: ").append(this.credentials()).append(",");
        }
        if (this.assumedRoleUser() != null) {
            sb.append("AssumedRoleUser: ").append(this.assumedRoleUser()).append(",");
        }
        if (this.packedPolicySize() != null) {
            sb.append("PackedPolicySize: ").append(this.packedPolicySize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "AssumedRoleUser": {
                return Optional.of(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Credentials credentials;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleResponse model) {
            this.credentials(model.credentials);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public AssumeRoleResponse build() {
            return new AssumeRoleResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssumeRoleResponse> {
        public Builder credentials(Credentials var1);

        public Builder assumedRoleUser(AssumedRoleUser var1);

        public Builder packedPolicySize(Integer var1);
    }
}

