/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetFederationTokenRequestMarshaller
implements Marshaller<Request<GetFederationTokenRequest>, GetFederationTokenRequest> {
    public Request<GetFederationTokenRequest> marshall(GetFederationTokenRequest getFederationTokenRequest) {
        if (getFederationTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getFederationTokenRequest, "STSClient");
        request.addParameter("Action", "GetFederationToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFederationTokenRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)getFederationTokenRequest.name()));
        }
        if (getFederationTokenRequest.policy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)getFederationTokenRequest.policy()));
        }
        if (getFederationTokenRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)getFederationTokenRequest.durationSeconds()));
        }
        return request;
    }
}

