/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetSessionTokenRequestMarshaller
implements Marshaller<Request<GetSessionTokenRequest>, GetSessionTokenRequest> {
    public Request<GetSessionTokenRequest> marshall(GetSessionTokenRequest getSessionTokenRequest) {
        if (getSessionTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSessionTokenRequest, "STSClient");
        request.addParameter("Action", "GetSessionToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSessionTokenRequest.durationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)getSessionTokenRequest.durationSeconds()));
        }
        if (getSessionTokenRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)getSessionTokenRequest.serialNumber()));
        }
        if (getSessionTokenRequest.tokenCode() != null) {
            request.addParameter("TokenCode", StringUtils.fromString((String)getSessionTokenRequest.tokenCode()));
        }
        return request;
    }
}

