/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.STSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleWithWebIdentityResponse
extends STSResponse
implements ToCopyableBuilder<Builder, AssumeRoleWithWebIdentityResponse> {
    private final Credentials credentials;
    private final String subjectFromWebIdentityToken;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;
    private final String provider;
    private final String audience;

    private AssumeRoleWithWebIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.subjectFromWebIdentityToken = builder.subjectFromWebIdentityToken;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
        this.provider = builder.provider;
        this.audience = builder.audience;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public String subjectFromWebIdentityToken() {
        return this.subjectFromWebIdentityToken;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public String provider() {
        return this.provider;
    }

    public String audience() {
        return this.audience;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectFromWebIdentityToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.packedPolicySize());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.audience());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleWithWebIdentityResponse)) {
            return false;
        }
        AssumeRoleWithWebIdentityResponse other = (AssumeRoleWithWebIdentityResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.subjectFromWebIdentityToken(), other.subjectFromWebIdentityToken()) && Objects.equals(this.assumedRoleUser(), other.assumedRoleUser()) && Objects.equals(this.packedPolicySize(), other.packedPolicySize()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.audience(), other.audience());
    }

    public String toString() {
        return ToString.builder((String)"AssumeRoleWithWebIdentityResponse").add("Credentials", (Object)this.credentials()).add("SubjectFromWebIdentityToken", (Object)this.subjectFromWebIdentityToken()).add("AssumedRoleUser", (Object)this.assumedRoleUser()).add("PackedPolicySize", (Object)this.packedPolicySize()).add("Provider", (Object)this.provider()).add("Audience", (Object)this.audience()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "SubjectFromWebIdentityToken": {
                return Optional.of(clazz.cast(this.subjectFromWebIdentityToken()));
            }
            case "AssumedRoleUser": {
                return Optional.of(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
            case "Provider": {
                return Optional.of(clazz.cast(this.provider()));
            }
            case "Audience": {
                return Optional.of(clazz.cast(this.audience()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private String subjectFromWebIdentityToken;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;
        private String provider;
        private String audience;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleWithWebIdentityResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.subjectFromWebIdentityToken(model.subjectFromWebIdentityToken);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
            this.provider(model.provider);
            this.audience(model.audience);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final String getSubjectFromWebIdentityToken() {
            return this.subjectFromWebIdentityToken;
        }

        @Override
        public final Builder subjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
            return this;
        }

        public final void setSubjectFromWebIdentityToken(String subjectFromWebIdentityToken) {
            this.subjectFromWebIdentityToken = subjectFromWebIdentityToken;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        public final String getProvider() {
            return this.provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        public final String getAudience() {
            return this.audience;
        }

        @Override
        public final Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public final void setAudience(String audience) {
            this.audience = audience;
        }

        @Override
        public AssumeRoleWithWebIdentityResponse build() {
            return new AssumeRoleWithWebIdentityResponse(this);
        }
    }

    public static interface Builder
    extends STSResponse.Builder,
    CopyableBuilder<Builder, AssumeRoleWithWebIdentityResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().apply(credentials)).build());
        }

        public Builder subjectFromWebIdentityToken(String var1);

        public Builder assumedRoleUser(AssumedRoleUser var1);

        default public Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return this.assumedRoleUser((AssumedRoleUser)((AssumedRoleUser.Builder)AssumedRoleUser.builder().apply(assumedRoleUser)).build());
        }

        public Builder packedPolicySize(Integer var1);

        public Builder provider(String var1);

        public Builder audience(String var1);
    }
}

