/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.sts.model.AssumedRoleUser;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.STSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssumeRoleResponse
extends STSResponse
implements ToCopyableBuilder<Builder, AssumeRoleResponse> {
    private final Credentials credentials;
    private final AssumedRoleUser assumedRoleUser;
    private final Integer packedPolicySize;

    private AssumeRoleResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
        this.assumedRoleUser = builder.assumedRoleUser;
        this.packedPolicySize = builder.packedPolicySize;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public AssumedRoleUser assumedRoleUser() {
        return this.assumedRoleUser;
    }

    public Integer packedPolicySize() {
        return this.packedPolicySize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.assumedRoleUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.packedPolicySize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeRoleResponse)) {
            return false;
        }
        AssumeRoleResponse other = (AssumeRoleResponse)((Object)obj);
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.assumedRoleUser(), other.assumedRoleUser()) && Objects.equals(this.packedPolicySize(), other.packedPolicySize());
    }

    public String toString() {
        return ToString.builder((String)"AssumeRoleResponse").add("Credentials", (Object)this.credentials()).add("AssumedRoleUser", (Object)this.assumedRoleUser()).add("PackedPolicySize", (Object)this.packedPolicySize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Credentials": {
                return Optional.of(clazz.cast(this.credentials()));
            }
            case "AssumedRoleUser": {
                return Optional.of(clazz.cast(this.assumedRoleUser()));
            }
            case "PackedPolicySize": {
                return Optional.of(clazz.cast(this.packedPolicySize()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends STSResponse.BuilderImpl
    implements Builder {
        private Credentials credentials;
        private AssumedRoleUser assumedRoleUser;
        private Integer packedPolicySize;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeRoleResponse model) {
            super(model);
            this.credentials(model.credentials);
            this.assumedRoleUser(model.assumedRoleUser);
            this.packedPolicySize(model.packedPolicySize);
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final AssumedRoleUser.Builder getAssumedRoleUser() {
            return this.assumedRoleUser != null ? this.assumedRoleUser.toBuilder() : null;
        }

        @Override
        public final Builder assumedRoleUser(AssumedRoleUser assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser;
            return this;
        }

        public final void setAssumedRoleUser(AssumedRoleUser.BuilderImpl assumedRoleUser) {
            this.assumedRoleUser = assumedRoleUser != null ? assumedRoleUser.build() : null;
        }

        public final Integer getPackedPolicySize() {
            return this.packedPolicySize;
        }

        @Override
        public final Builder packedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
            return this;
        }

        public final void setPackedPolicySize(Integer packedPolicySize) {
            this.packedPolicySize = packedPolicySize;
        }

        @Override
        public AssumeRoleResponse build() {
            return new AssumeRoleResponse(this);
        }
    }

    public static interface Builder
    extends STSResponse.Builder,
    CopyableBuilder<Builder, AssumeRoleResponse> {
        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().apply(credentials)).build());
        }

        public Builder assumedRoleUser(AssumedRoleUser var1);

        default public Builder assumedRoleUser(Consumer<AssumedRoleUser.Builder> assumedRoleUser) {
            return this.assumedRoleUser((AssumedRoleUser)((AssumedRoleUser.Builder)AssumedRoleUser.builder().apply(assumedRoleUser)).build());
        }

        public Builder packedPolicySize(Integer var1);
    }
}

