/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sts.STSAsyncClient;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSAMLResponse;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityResponse;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageRequest;
import software.amazon.awssdk.services.sts.model.DecodeAuthorizationMessageResponse;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.STSException;
import software.amazon.awssdk.services.sts.transform.AssumeRoleRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithSAMLResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.AssumeRoleWithWebIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.DecodeAuthorizationMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.ExpiredTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetCallerIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetFederationTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenRequestMarshaller;
import software.amazon.awssdk.services.sts.transform.GetSessionTokenResponseUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPCommunicationErrorExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.IDPRejectedClaimExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidAuthorizationMessageExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.InvalidIdentityTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.MalformedPolicyDocumentExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.PackedPolicyTooLargeExceptionUnmarshaller;
import software.amazon.awssdk.services.sts.transform.RegionDisabledExceptionUnmarshaller;

@SdkInternalApi
final class DefaultSTSAsyncClient
implements STSAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultSTSAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CompletableFuture<AssumeRoleResponse> assumeRole(AssumeRoleRequest assumeRoleRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)assumeRoleRequest));
    }

    @Override
    public CompletableFuture<AssumeRoleWithSAMLResponse> assumeRoleWithSAML(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithSAMLResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleWithSAMLRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)assumeRoleWithSAMLRequest));
    }

    @Override
    public CompletableFuture<AssumeRoleWithWebIdentityResponse> assumeRoleWithWebIdentity(AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AssumeRoleWithWebIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AssumeRoleWithWebIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)assumeRoleWithWebIdentityRequest));
    }

    @Override
    public CompletableFuture<DecodeAuthorizationMessageResponse> decodeAuthorizationMessage(DecodeAuthorizationMessageRequest decodeAuthorizationMessageRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DecodeAuthorizationMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DecodeAuthorizationMessageRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)decodeAuthorizationMessageRequest));
    }

    @Override
    public CompletableFuture<GetCallerIdentityResponse> getCallerIdentity(GetCallerIdentityRequest getCallerIdentityRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCallerIdentityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCallerIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getCallerIdentityRequest));
    }

    @Override
    public CompletableFuture<GetFederationTokenResponse> getFederationToken(GetFederationTokenRequest getFederationTokenRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetFederationTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetFederationTokenRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getFederationTokenRequest));
    }

    @Override
    public CompletableFuture<GetSessionTokenResponse> getSessionToken(GetSessionTokenRequest getSessionTokenRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetSessionTokenResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetSessionTokenRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getSessionTokenRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidAuthorizationMessageExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ExpiredTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PackedPolicyTooLargeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new RegionDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MalformedPolicyDocumentExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new IDPCommunicationErrorExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidIdentityTokenExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new IDPRejectedClaimExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(STSException.class));
        return unmarshallers;
    }
}

