/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.HostsCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinDomainRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, JoinDomainRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(JoinDomainRequest.getter(JoinDomainRequest::gatewayARN)).setter(JoinDomainRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(JoinDomainRequest.getter(JoinDomainRequest::domainName)).setter(JoinDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnit").getter(JoinDomainRequest.getter(JoinDomainRequest::organizationalUnit)).setter(JoinDomainRequest.setter(Builder::organizationalUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnit").build()}).build();
    private static final SdkField<List<String>> DOMAIN_CONTROLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainControllers").getter(JoinDomainRequest.getter(JoinDomainRequest::domainControllers)).setter(JoinDomainRequest.setter(Builder::domainControllers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInSeconds").getter(JoinDomainRequest.getter(JoinDomainRequest::timeoutInSeconds)).setter(JoinDomainRequest.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(JoinDomainRequest.getter(JoinDomainRequest::userName)).setter(JoinDomainRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(JoinDomainRequest.getter(JoinDomainRequest::password)).setter(JoinDomainRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_FIELD, DOMAIN_CONTROLLERS_FIELD, TIMEOUT_IN_SECONDS_FIELD, USER_NAME_FIELD, PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JoinDomainRequest.memberNameToFieldInitializer();
    private final String gatewayARN;
    private final String domainName;
    private final String organizationalUnit;
    private final List<String> domainControllers;
    private final Integer timeoutInSeconds;
    private final String userName;
    private final String password;

    private JoinDomainRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.domainName = builder.domainName;
        this.organizationalUnit = builder.organizationalUnit;
        this.domainControllers = builder.domainControllers;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.userName = builder.userName;
        this.password = builder.password;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String organizationalUnit() {
        return this.organizationalUnit;
    }

    public final boolean hasDomainControllers() {
        return this.domainControllers != null && !(this.domainControllers instanceof SdkAutoConstructList);
    }

    public final List<String> domainControllers() {
        return this.domainControllers;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final String userName() {
        return this.userName;
    }

    public final String password() {
        return this.password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainControllers() ? this.domainControllers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinDomainRequest)) {
            return false;
        }
        JoinDomainRequest other = (JoinDomainRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.organizationalUnit(), other.organizationalUnit()) && this.hasDomainControllers() == other.hasDomainControllers() && Objects.equals(this.domainControllers(), other.domainControllers()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.password(), other.password());
    }

    public final String toString() {
        return ToString.builder((String)"JoinDomainRequest").add("GatewayARN", (Object)this.gatewayARN()).add("DomainName", (Object)this.domainName()).add("OrganizationalUnit", (Object)this.organizationalUnit()).add("DomainControllers", this.hasDomainControllers() ? this.domainControllers() : null).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("UserName", (Object)this.userName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "OrganizationalUnit": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnit()));
            }
            case "DomainControllers": {
                return Optional.ofNullable(clazz.cast(this.domainControllers()));
            }
            case "TimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GatewayARN", GATEWAY_ARN_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("OrganizationalUnit", ORGANIZATIONAL_UNIT_FIELD);
        map.put("DomainControllers", DOMAIN_CONTROLLERS_FIELD);
        map.put("TimeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinDomainRequest, T> g) {
        return obj -> g.apply((JoinDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String domainName;
        private String organizationalUnit;
        private List<String> domainControllers = DefaultSdkAutoConstructList.getInstance();
        private Integer timeoutInSeconds;
        private String userName;
        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinDomainRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.domainName(model.domainName);
            this.organizationalUnit(model.organizationalUnit);
            this.domainControllers(model.domainControllers);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.userName(model.userName);
            this.password(model.password);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getOrganizationalUnit() {
            return this.organizationalUnit;
        }

        public final void setOrganizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
        }

        @Override
        public final Builder organizationalUnit(String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public final Collection<String> getDomainControllers() {
            if (this.domainControllers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.domainControllers;
        }

        public final void setDomainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
        }

        @Override
        public final Builder domainControllers(Collection<String> domainControllers) {
            this.domainControllers = HostsCopier.copy(domainControllers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(String ... domainControllers) {
            this.domainControllers(Arrays.asList(domainControllers));
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public JoinDomainRequest build() {
            return new JoinDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, JoinDomainRequest> {
        public Builder gatewayARN(String var1);

        public Builder domainName(String var1);

        public Builder organizationalUnit(String var1);

        public Builder domainControllers(Collection<String> var1);

        public Builder domainControllers(String ... var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder userName(String var1);

        public Builder password(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

