/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvictFilesFailingUploadRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, EvictFilesFailingUploadRequest> {
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(EvictFilesFailingUploadRequest.getter(EvictFilesFailingUploadRequest::fileShareARN)).setter(EvictFilesFailingUploadRequest.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<Boolean> FORCE_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceRemove").getter(EvictFilesFailingUploadRequest.getter(EvictFilesFailingUploadRequest::forceRemove)).setter(EvictFilesFailingUploadRequest.setter(Builder::forceRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceRemove").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SHARE_ARN_FIELD, FORCE_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvictFilesFailingUploadRequest.memberNameToFieldInitializer();
    private final String fileShareARN;
    private final Boolean forceRemove;

    private EvictFilesFailingUploadRequest(BuilderImpl builder) {
        super(builder);
        this.fileShareARN = builder.fileShareARN;
        this.forceRemove = builder.forceRemove;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final Boolean forceRemove() {
        return this.forceRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceRemove());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvictFilesFailingUploadRequest)) {
            return false;
        }
        EvictFilesFailingUploadRequest other = (EvictFilesFailingUploadRequest)((Object)obj);
        return Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.forceRemove(), other.forceRemove());
    }

    public final String toString() {
        return ToString.builder((String)"EvictFilesFailingUploadRequest").add("FileShareARN", (Object)this.fileShareARN()).add("ForceRemove", (Object)this.forceRemove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "ForceRemove": {
                return Optional.ofNullable(clazz.cast(this.forceRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("ForceRemove", FORCE_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvictFilesFailingUploadRequest, T> g) {
        return obj -> g.apply((EvictFilesFailingUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String fileShareARN;
        private Boolean forceRemove;

        private BuilderImpl() {
        }

        private BuilderImpl(EvictFilesFailingUploadRequest model) {
            super(model);
            this.fileShareARN(model.fileShareARN);
            this.forceRemove(model.forceRemove);
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final Boolean getForceRemove() {
            return this.forceRemove;
        }

        public final void setForceRemove(Boolean forceRemove) {
            this.forceRemove = forceRemove;
        }

        @Override
        public final Builder forceRemove(Boolean forceRemove) {
            this.forceRemove = forceRemove;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvictFilesFailingUploadRequest build() {
            return new EvictFilesFailingUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvictFilesFailingUploadRequest> {
        public Builder fileShareARN(String var1);

        public Builder forceRemove(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

