/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheReportFilter;
import software.amazon.awssdk.services.storagegateway.model.CacheReportFilterListCopier;
import software.amazon.awssdk.services.storagegateway.model.CacheReportStatus;
import software.amazon.awssdk.services.storagegateway.model.Tag;
import software.amazon.awssdk.services.storagegateway.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheReportInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheReportInfo> {
    private static final SdkField<String> CACHE_REPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheReportARN").getter(CacheReportInfo.getter(CacheReportInfo::cacheReportARN)).setter(CacheReportInfo.setter(Builder::cacheReportARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportARN").build()}).build();
    private static final SdkField<String> CACHE_REPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheReportStatus").getter(CacheReportInfo.getter(CacheReportInfo::cacheReportStatusAsString)).setter(CacheReportInfo.setter(Builder::cacheReportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportStatus").build()}).build();
    private static final SdkField<Integer> REPORT_COMPLETION_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReportCompletionPercent").getter(CacheReportInfo.getter(CacheReportInfo::reportCompletionPercent)).setter(CacheReportInfo.setter(Builder::reportCompletionPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportCompletionPercent").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CacheReportInfo.getter(CacheReportInfo::endTime)).setter(CacheReportInfo.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CacheReportInfo.getter(CacheReportInfo::role)).setter(CacheReportInfo.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> FILE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileShareARN").getter(CacheReportInfo.getter(CacheReportInfo::fileShareARN)).setter(CacheReportInfo.setter(Builder::fileShareARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileShareARN").build()}).build();
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationARN").getter(CacheReportInfo.getter(CacheReportInfo::locationARN)).setter(CacheReportInfo.setter(Builder::locationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationARN").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CacheReportInfo.getter(CacheReportInfo::startTime)).setter(CacheReportInfo.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<List<CacheReportFilter>> INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionFilters").getter(CacheReportInfo.getter(CacheReportInfo::inclusionFilters)).setter(CacheReportInfo.setter(Builder::inclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheReportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CacheReportFilter>> EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionFilters").getter(CacheReportInfo.getter(CacheReportInfo::exclusionFilters)).setter(CacheReportInfo.setter(Builder::exclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheReportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportName").getter(CacheReportInfo.getter(CacheReportInfo::reportName)).setter(CacheReportInfo.setter(Builder::reportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CacheReportInfo.getter(CacheReportInfo::tags)).setter(CacheReportInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_REPORT_ARN_FIELD, CACHE_REPORT_STATUS_FIELD, REPORT_COMPLETION_PERCENT_FIELD, END_TIME_FIELD, ROLE_FIELD, FILE_SHARE_ARN_FIELD, LOCATION_ARN_FIELD, START_TIME_FIELD, INCLUSION_FILTERS_FIELD, EXCLUSION_FILTERS_FIELD, REPORT_NAME_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheReportInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cacheReportARN;
    private final String cacheReportStatus;
    private final Integer reportCompletionPercent;
    private final Instant endTime;
    private final String role;
    private final String fileShareARN;
    private final String locationARN;
    private final Instant startTime;
    private final List<CacheReportFilter> inclusionFilters;
    private final List<CacheReportFilter> exclusionFilters;
    private final String reportName;
    private final List<Tag> tags;

    private CacheReportInfo(BuilderImpl builder) {
        this.cacheReportARN = builder.cacheReportARN;
        this.cacheReportStatus = builder.cacheReportStatus;
        this.reportCompletionPercent = builder.reportCompletionPercent;
        this.endTime = builder.endTime;
        this.role = builder.role;
        this.fileShareARN = builder.fileShareARN;
        this.locationARN = builder.locationARN;
        this.startTime = builder.startTime;
        this.inclusionFilters = builder.inclusionFilters;
        this.exclusionFilters = builder.exclusionFilters;
        this.reportName = builder.reportName;
        this.tags = builder.tags;
    }

    public final String cacheReportARN() {
        return this.cacheReportARN;
    }

    public final CacheReportStatus cacheReportStatus() {
        return CacheReportStatus.fromValue(this.cacheReportStatus);
    }

    public final String cacheReportStatusAsString() {
        return this.cacheReportStatus;
    }

    public final Integer reportCompletionPercent() {
        return this.reportCompletionPercent;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String role() {
        return this.role;
    }

    public final String fileShareARN() {
        return this.fileShareARN;
    }

    public final String locationARN() {
        return this.locationARN;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasInclusionFilters() {
        return this.inclusionFilters != null && !(this.inclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<CacheReportFilter> inclusionFilters() {
        return this.inclusionFilters;
    }

    public final boolean hasExclusionFilters() {
        return this.exclusionFilters != null && !(this.exclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<CacheReportFilter> exclusionFilters() {
        return this.exclusionFilters;
    }

    public final String reportName() {
        return this.reportName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheReportARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheReportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportCompletionPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileShareARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFilters() ? this.inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFilters() ? this.exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheReportInfo)) {
            return false;
        }
        CacheReportInfo other = (CacheReportInfo)obj;
        return Objects.equals(this.cacheReportARN(), other.cacheReportARN()) && Objects.equals(this.cacheReportStatusAsString(), other.cacheReportStatusAsString()) && Objects.equals(this.reportCompletionPercent(), other.reportCompletionPercent()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.fileShareARN(), other.fileShareARN()) && Objects.equals(this.locationARN(), other.locationARN()) && Objects.equals(this.startTime(), other.startTime()) && this.hasInclusionFilters() == other.hasInclusionFilters() && Objects.equals(this.inclusionFilters(), other.inclusionFilters()) && this.hasExclusionFilters() == other.hasExclusionFilters() && Objects.equals(this.exclusionFilters(), other.exclusionFilters()) && Objects.equals(this.reportName(), other.reportName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CacheReportInfo").add("CacheReportARN", (Object)this.cacheReportARN()).add("CacheReportStatus", (Object)this.cacheReportStatusAsString()).add("ReportCompletionPercent", (Object)this.reportCompletionPercent()).add("EndTime", (Object)this.endTime()).add("Role", (Object)this.role()).add("FileShareARN", (Object)this.fileShareARN()).add("LocationARN", (Object)this.locationARN()).add("StartTime", (Object)this.startTime()).add("InclusionFilters", this.hasInclusionFilters() ? this.inclusionFilters() : null).add("ExclusionFilters", this.hasExclusionFilters() ? this.exclusionFilters() : null).add("ReportName", (Object)this.reportName()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheReportARN": {
                return Optional.ofNullable(clazz.cast(this.cacheReportARN()));
            }
            case "CacheReportStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheReportStatusAsString()));
            }
            case "ReportCompletionPercent": {
                return Optional.ofNullable(clazz.cast(this.reportCompletionPercent()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "FileShareARN": {
                return Optional.ofNullable(clazz.cast(this.fileShareARN()));
            }
            case "LocationARN": {
                return Optional.ofNullable(clazz.cast(this.locationARN()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "InclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.inclusionFilters()));
            }
            case "ExclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.exclusionFilters()));
            }
            case "ReportName": {
                return Optional.ofNullable(clazz.cast(this.reportName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CacheReportARN", CACHE_REPORT_ARN_FIELD);
        map.put("CacheReportStatus", CACHE_REPORT_STATUS_FIELD);
        map.put("ReportCompletionPercent", REPORT_COMPLETION_PERCENT_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("FileShareARN", FILE_SHARE_ARN_FIELD);
        map.put("LocationARN", LOCATION_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("InclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("ExclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("ReportName", REPORT_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheReportInfo, T> g) {
        return obj -> g.apply((CacheReportInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheReportARN;
        private String cacheReportStatus;
        private Integer reportCompletionPercent;
        private Instant endTime;
        private String role;
        private String fileShareARN;
        private String locationARN;
        private Instant startTime;
        private List<CacheReportFilter> inclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CacheReportFilter> exclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private String reportName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CacheReportInfo model) {
            this.cacheReportARN(model.cacheReportARN);
            this.cacheReportStatus(model.cacheReportStatus);
            this.reportCompletionPercent(model.reportCompletionPercent);
            this.endTime(model.endTime);
            this.role(model.role);
            this.fileShareARN(model.fileShareARN);
            this.locationARN(model.locationARN);
            this.startTime(model.startTime);
            this.inclusionFilters(model.inclusionFilters);
            this.exclusionFilters(model.exclusionFilters);
            this.reportName(model.reportName);
            this.tags(model.tags);
        }

        public final String getCacheReportARN() {
            return this.cacheReportARN;
        }

        public final void setCacheReportARN(String cacheReportARN) {
            this.cacheReportARN = cacheReportARN;
        }

        @Override
        public final Builder cacheReportARN(String cacheReportARN) {
            this.cacheReportARN = cacheReportARN;
            return this;
        }

        public final String getCacheReportStatus() {
            return this.cacheReportStatus;
        }

        public final void setCacheReportStatus(String cacheReportStatus) {
            this.cacheReportStatus = cacheReportStatus;
        }

        @Override
        public final Builder cacheReportStatus(String cacheReportStatus) {
            this.cacheReportStatus = cacheReportStatus;
            return this;
        }

        @Override
        public final Builder cacheReportStatus(CacheReportStatus cacheReportStatus) {
            this.cacheReportStatus(cacheReportStatus == null ? null : cacheReportStatus.toString());
            return this;
        }

        public final Integer getReportCompletionPercent() {
            return this.reportCompletionPercent;
        }

        public final void setReportCompletionPercent(Integer reportCompletionPercent) {
            this.reportCompletionPercent = reportCompletionPercent;
        }

        @Override
        public final Builder reportCompletionPercent(Integer reportCompletionPercent) {
            this.reportCompletionPercent = reportCompletionPercent;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getFileShareARN() {
            return this.fileShareARN;
        }

        public final void setFileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
        }

        @Override
        public final Builder fileShareARN(String fileShareARN) {
            this.fileShareARN = fileShareARN;
            return this;
        }

        public final String getLocationARN() {
            return this.locationARN;
        }

        public final void setLocationARN(String locationARN) {
            this.locationARN = locationARN;
        }

        @Override
        public final Builder locationARN(String locationARN) {
            this.locationARN = locationARN;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<CacheReportFilter.Builder> getInclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.inclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInclusionFilters(Collection<CacheReportFilter.BuilderImpl> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copyFromBuilder(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<CacheReportFilter> inclusionFilters) {
            this.inclusionFilters = CacheReportFilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(CacheReportFilter ... inclusionFilters) {
            this.inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(Consumer<CacheReportFilter.Builder> ... inclusionFilters) {
            this.inclusionFilters(Stream.of(inclusionFilters).map(c -> (CacheReportFilter)((CacheReportFilter.Builder)CacheReportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CacheReportFilter.Builder> getExclusionFilters() {
            List<CacheReportFilter.Builder> result = CacheReportFilterListCopier.copyToBuilder(this.exclusionFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExclusionFilters(Collection<CacheReportFilter.BuilderImpl> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copyFromBuilder(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<CacheReportFilter> exclusionFilters) {
            this.exclusionFilters = CacheReportFilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(CacheReportFilter ... exclusionFilters) {
            this.exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(Consumer<CacheReportFilter.Builder> ... exclusionFilters) {
            this.exclusionFilters(Stream.of(exclusionFilters).map(c -> (CacheReportFilter)((CacheReportFilter.Builder)CacheReportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReportName() {
            return this.reportName;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CacheReportInfo build() {
            return new CacheReportInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheReportInfo> {
        public Builder cacheReportARN(String var1);

        public Builder cacheReportStatus(String var1);

        public Builder cacheReportStatus(CacheReportStatus var1);

        public Builder reportCompletionPercent(Integer var1);

        public Builder endTime(Instant var1);

        public Builder role(String var1);

        public Builder fileShareARN(String var1);

        public Builder locationARN(String var1);

        public Builder startTime(Instant var1);

        public Builder inclusionFilters(Collection<CacheReportFilter> var1);

        public Builder inclusionFilters(CacheReportFilter ... var1);

        public Builder inclusionFilters(Consumer<CacheReportFilter.Builder> ... var1);

        public Builder exclusionFilters(Collection<CacheReportFilter> var1);

        public Builder exclusionFilters(CacheReportFilter ... var1);

        public Builder exclusionFilters(Consumer<CacheReportFilter.Builder> ... var1);

        public Builder reportName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

