/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeTapeRecoveryPointsResponse;
import software.amazon.awssdk.services.storagegateway.model.TapeRecoveryPointInfo;

public class DescribeTapeRecoveryPointsPublisher
implements SdkPublisher<DescribeTapeRecoveryPointsResponse> {
    private final StorageGatewayAsyncClient client;
    private final DescribeTapeRecoveryPointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTapeRecoveryPointsPublisher(StorageGatewayAsyncClient client, DescribeTapeRecoveryPointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTapeRecoveryPointsPublisher(StorageGatewayAsyncClient client, DescribeTapeRecoveryPointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTapeRecoveryPointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTapeRecoveryPointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TapeRecoveryPointInfo> tapeRecoveryPointInfos() {
        Function<DescribeTapeRecoveryPointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tapeRecoveryPointInfos() != null) {
                return response.tapeRecoveryPointInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTapeRecoveryPointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTapeRecoveryPointsResponseFetcher
    implements AsyncPageFetcher<DescribeTapeRecoveryPointsResponse> {
        private DescribeTapeRecoveryPointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTapeRecoveryPointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTapeRecoveryPointsResponse> nextPage(DescribeTapeRecoveryPointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTapeRecoveryPointsPublisher.this.client.describeTapeRecoveryPoints(DescribeTapeRecoveryPointsPublisher.this.firstRequest);
            }
            return DescribeTapeRecoveryPointsPublisher.this.client.describeTapeRecoveryPoints((DescribeTapeRecoveryPointsRequest)((Object)DescribeTapeRecoveryPointsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

