/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TapeStorageClass {
    DEEP_ARCHIVE("DEEP_ARCHIVE"),
    GLACIER("GLACIER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TapeStorageClass> VALUE_MAP;
    private final String value;

    private TapeStorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TapeStorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TapeStorageClass> knownValues() {
        EnumSet<TapeStorageClass> knownValues = EnumSet.allOf(TapeStorageClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TapeStorageClass.class, TapeStorageClass::toString);
    }
}

