/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.CacheReportInfo;
import software.amazon.awssdk.services.storagegateway.model.CacheReportListCopier;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCacheReportsResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, ListCacheReportsResponse> {
    private static final SdkField<List<CacheReportInfo>> CACHE_REPORT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheReportList").getter(ListCacheReportsResponse.getter(ListCacheReportsResponse::cacheReportList)).setter(ListCacheReportsResponse.setter(Builder::cacheReportList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheReportList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheReportInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListCacheReportsResponse.getter(ListCacheReportsResponse::marker)).setter(ListCacheReportsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_REPORT_LIST_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCacheReportsResponse.memberNameToFieldInitializer();
    private final List<CacheReportInfo> cacheReportList;
    private final String marker;

    private ListCacheReportsResponse(BuilderImpl builder) {
        super(builder);
        this.cacheReportList = builder.cacheReportList;
        this.marker = builder.marker;
    }

    public final boolean hasCacheReportList() {
        return this.cacheReportList != null && !(this.cacheReportList instanceof SdkAutoConstructList);
    }

    public final List<CacheReportInfo> cacheReportList() {
        return this.cacheReportList;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheReportList() ? this.cacheReportList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCacheReportsResponse)) {
            return false;
        }
        ListCacheReportsResponse other = (ListCacheReportsResponse)((Object)obj);
        return this.hasCacheReportList() == other.hasCacheReportList() && Objects.equals(this.cacheReportList(), other.cacheReportList()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListCacheReportsResponse").add("CacheReportList", this.hasCacheReportList() ? this.cacheReportList() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheReportList": {
                return Optional.ofNullable(clazz.cast(this.cacheReportList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CacheReportList", CACHE_REPORT_LIST_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCacheReportsResponse, T> g) {
        return obj -> g.apply((ListCacheReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<CacheReportInfo> cacheReportList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCacheReportsResponse model) {
            super(model);
            this.cacheReportList(model.cacheReportList);
            this.marker(model.marker);
        }

        public final List<CacheReportInfo.Builder> getCacheReportList() {
            List<CacheReportInfo.Builder> result = CacheReportListCopier.copyToBuilder(this.cacheReportList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheReportList(Collection<CacheReportInfo.BuilderImpl> cacheReportList) {
            this.cacheReportList = CacheReportListCopier.copyFromBuilder(cacheReportList);
        }

        @Override
        public final Builder cacheReportList(Collection<CacheReportInfo> cacheReportList) {
            this.cacheReportList = CacheReportListCopier.copy(cacheReportList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheReportList(CacheReportInfo ... cacheReportList) {
            this.cacheReportList(Arrays.asList(cacheReportList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheReportList(Consumer<CacheReportInfo.Builder> ... cacheReportList) {
            this.cacheReportList(Stream.of(cacheReportList).map(c -> (CacheReportInfo)((CacheReportInfo.Builder)CacheReportInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListCacheReportsResponse build() {
            return new ListCacheReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCacheReportsResponse> {
        public Builder cacheReportList(Collection<CacheReportInfo> var1);

        public Builder cacheReportList(CacheReportInfo ... var1);

        public Builder cacheReportList(Consumer<CacheReportInfo.Builder> ... var1);

        public Builder marker(String var1);
    }
}

