/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChapCredentialsRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateChapCredentialsRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetARN").getter(UpdateChapCredentialsRequest.getter(UpdateChapCredentialsRequest::targetARN)).setter(UpdateChapCredentialsRequest.setter(Builder::targetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()}).build();
    private static final SdkField<String> SECRET_TO_AUTHENTICATE_INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretToAuthenticateInitiator").getter(UpdateChapCredentialsRequest.getter(UpdateChapCredentialsRequest::secretToAuthenticateInitiator)).setter(UpdateChapCredentialsRequest.setter(Builder::secretToAuthenticateInitiator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateInitiator").build()}).build();
    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatorName").getter(UpdateChapCredentialsRequest.getter(UpdateChapCredentialsRequest::initiatorName)).setter(UpdateChapCredentialsRequest.setter(Builder::initiatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()}).build();
    private static final SdkField<String> SECRET_TO_AUTHENTICATE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretToAuthenticateTarget").getter(UpdateChapCredentialsRequest.getter(UpdateChapCredentialsRequest::secretToAuthenticateTarget)).setter(UpdateChapCredentialsRequest.setter(Builder::secretToAuthenticateTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToAuthenticateTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, SECRET_TO_AUTHENTICATE_INITIATOR_FIELD, INITIATOR_NAME_FIELD, SECRET_TO_AUTHENTICATE_TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateChapCredentialsRequest.memberNameToFieldInitializer();
    private final String targetARN;
    private final String secretToAuthenticateInitiator;
    private final String initiatorName;
    private final String secretToAuthenticateTarget;

    private UpdateChapCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.targetARN = builder.targetARN;
        this.secretToAuthenticateInitiator = builder.secretToAuthenticateInitiator;
        this.initiatorName = builder.initiatorName;
        this.secretToAuthenticateTarget = builder.secretToAuthenticateTarget;
    }

    public final String targetARN() {
        return this.targetARN;
    }

    public final String secretToAuthenticateInitiator() {
        return this.secretToAuthenticateInitiator;
    }

    public final String initiatorName() {
        return this.initiatorName;
    }

    public final String secretToAuthenticateTarget() {
        return this.secretToAuthenticateTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToAuthenticateInitiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretToAuthenticateTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChapCredentialsRequest)) {
            return false;
        }
        UpdateChapCredentialsRequest other = (UpdateChapCredentialsRequest)((Object)obj);
        return Objects.equals(this.targetARN(), other.targetARN()) && Objects.equals(this.secretToAuthenticateInitiator(), other.secretToAuthenticateInitiator()) && Objects.equals(this.initiatorName(), other.initiatorName()) && Objects.equals(this.secretToAuthenticateTarget(), other.secretToAuthenticateTarget());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChapCredentialsRequest").add("TargetARN", (Object)this.targetARN()).add("SecretToAuthenticateInitiator", (Object)(this.secretToAuthenticateInitiator() == null ? null : "*** Sensitive Data Redacted ***")).add("InitiatorName", (Object)this.initiatorName()).add("SecretToAuthenticateTarget", (Object)(this.secretToAuthenticateTarget() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetARN": {
                return Optional.ofNullable(clazz.cast(this.targetARN()));
            }
            case "SecretToAuthenticateInitiator": {
                return Optional.ofNullable(clazz.cast(this.secretToAuthenticateInitiator()));
            }
            case "InitiatorName": {
                return Optional.ofNullable(clazz.cast(this.initiatorName()));
            }
            case "SecretToAuthenticateTarget": {
                return Optional.ofNullable(clazz.cast(this.secretToAuthenticateTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TargetARN", TARGET_ARN_FIELD);
        map.put("SecretToAuthenticateInitiator", SECRET_TO_AUTHENTICATE_INITIATOR_FIELD);
        map.put("InitiatorName", INITIATOR_NAME_FIELD);
        map.put("SecretToAuthenticateTarget", SECRET_TO_AUTHENTICATE_TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateChapCredentialsRequest, T> g) {
        return obj -> g.apply((UpdateChapCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String targetARN;
        private String secretToAuthenticateInitiator;
        private String initiatorName;
        private String secretToAuthenticateTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChapCredentialsRequest model) {
            super(model);
            this.targetARN(model.targetARN);
            this.secretToAuthenticateInitiator(model.secretToAuthenticateInitiator);
            this.initiatorName(model.initiatorName);
            this.secretToAuthenticateTarget(model.secretToAuthenticateTarget);
        }

        public final String getTargetARN() {
            return this.targetARN;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final String getSecretToAuthenticateInitiator() {
            return this.secretToAuthenticateInitiator;
        }

        public final void setSecretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
        }

        @Override
        public final Builder secretToAuthenticateInitiator(String secretToAuthenticateInitiator) {
            this.secretToAuthenticateInitiator = secretToAuthenticateInitiator;
            return this;
        }

        public final String getInitiatorName() {
            return this.initiatorName;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final String getSecretToAuthenticateTarget() {
            return this.secretToAuthenticateTarget;
        }

        public final void setSecretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
        }

        @Override
        public final Builder secretToAuthenticateTarget(String secretToAuthenticateTarget) {
            this.secretToAuthenticateTarget = secretToAuthenticateTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChapCredentialsRequest build() {
            return new UpdateChapCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChapCredentialsRequest> {
        public Builder targetARN(String var1);

        public Builder secretToAuthenticateInitiator(String var1);

        public Builder initiatorName(String var1);

        public Builder secretToAuthenticateTarget(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

