/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.storagegateway.model.FileSystemAssociationSummary;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsRequest;
import software.amazon.awssdk.services.storagegateway.model.ListFileSystemAssociationsResponse;

public class ListFileSystemAssociationsPublisher
implements SdkPublisher<ListFileSystemAssociationsResponse> {
    private final StorageGatewayAsyncClient client;
    private final ListFileSystemAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFileSystemAssociationsPublisher(StorageGatewayAsyncClient client, ListFileSystemAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFileSystemAssociationsPublisher(StorageGatewayAsyncClient client, ListFileSystemAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFileSystemAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFileSystemAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FileSystemAssociationSummary> fileSystemAssociationSummaryList() {
        Function<ListFileSystemAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fileSystemAssociationSummaryList() != null) {
                return response.fileSystemAssociationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFileSystemAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFileSystemAssociationsResponseFetcher
    implements AsyncPageFetcher<ListFileSystemAssociationsResponse> {
        private ListFileSystemAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFileSystemAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFileSystemAssociationsResponse> nextPage(ListFileSystemAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFileSystemAssociationsPublisher.this.client.listFileSystemAssociations(ListFileSystemAssociationsPublisher.this.firstRequest);
            }
            return ListFileSystemAssociationsPublisher.this.client.listFileSystemAssociations((ListFileSystemAssociationsRequest)((Object)ListFileSystemAssociationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

