/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateFileSystemResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DisassociateFileSystemResponse.Builder, DisassociateFileSystemResponse> {
    private static final SdkField<String> FILE_SYSTEM_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAssociationARN").getter(getter(DisassociateFileSystemResponse::fileSystemAssociationARN))
            .setter(setter(Builder::fileSystemAssociationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAssociationARN").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FILE_SYSTEM_ASSOCIATION_ARN_FIELD));

    private final String fileSystemAssociationARN;

    private DisassociateFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.fileSystemAssociationARN = builder.fileSystemAssociationARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deleted file system association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deleted file system association.
     */
    public final String fileSystemAssociationARN() {
        return fileSystemAssociationARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAssociationARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateFileSystemResponse)) {
            return false;
        }
        DisassociateFileSystemResponse other = (DisassociateFileSystemResponse) obj;
        return Objects.equals(fileSystemAssociationARN(), other.fileSystemAssociationARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateFileSystemResponse").add("FileSystemAssociationARN", fileSystemAssociationARN())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemAssociationARN":
            return Optional.ofNullable(clazz.cast(fileSystemAssociationARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateFileSystemResponse, T> g) {
        return obj -> g.apply((DisassociateFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateFileSystemResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deleted file system association.
         * </p>
         * 
         * @param fileSystemAssociationARN
         *        The Amazon Resource Name (ARN) of the deleted file system association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAssociationARN(String fileSystemAssociationARN);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String fileSystemAssociationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateFileSystemResponse model) {
            super(model);
            fileSystemAssociationARN(model.fileSystemAssociationARN);
        }

        public final String getFileSystemAssociationARN() {
            return fileSystemAssociationARN;
        }

        public final void setFileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
        }

        @Override
        public final Builder fileSystemAssociationARN(String fileSystemAssociationARN) {
            this.fileSystemAssociationARN = fileSystemAssociationARN;
            return this;
        }

        @Override
        public DisassociateFileSystemResponse build() {
            return new DisassociateFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
