/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes the sign-in options for an application portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SignInOptions implements SdkPojo, Serializable, ToCopyableBuilder<SignInOptions.Builder, SignInOptions> {
    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(SignInOptions::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationUrl").getter(getter(SignInOptions::applicationUrl)).setter(setter(Builder::applicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_FIELD,
            APPLICATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String origin;

    private final String applicationUrl;

    private SignInOptions(BuilderImpl builder) {
        this.origin = builder.origin;
        this.applicationUrl = builder.applicationUrl;
    }

    /**
     * <p>
     * This determines how IAM Identity Center navigates the user to the target application. It can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
     * <code>ApplicationUrl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to sign
     * the customer directly into a SAML-based application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link SignInOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return This determines how IAM Identity Center navigates the user to the target application. It can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
     *         <code>ApplicationUrl</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to
     *         sign the customer directly into a SAML-based application.
     *         </p>
     *         </li>
     * @see SignInOrigin
     */
    public final SignInOrigin origin() {
        return SignInOrigin.fromValue(origin);
    }

    /**
     * <p>
     * This determines how IAM Identity Center navigates the user to the target application. It can be one of the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
     * <code>ApplicationUrl</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to sign
     * the customer directly into a SAML-based application.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link SignInOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return This determines how IAM Identity Center navigates the user to the target application. It can be one of
     *         the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
     *         <code>ApplicationUrl</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to
     *         sign the customer directly into a SAML-based application.
     *         </p>
     *         </li>
     * @see SignInOrigin
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The URL that accepts authentication requests for an application. This is a required parameter if the
     * <code>Origin</code> parameter is <code>APPLICATION</code>.
     * </p>
     * 
     * @return The URL that accepts authentication requests for an application. This is a required parameter if the
     *         <code>Origin</code> parameter is <code>APPLICATION</code>.
     */
    public final String applicationUrl() {
        return applicationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignInOptions)) {
            return false;
        }
        SignInOptions other = (SignInOptions) obj;
        return Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(applicationUrl(), other.applicationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SignInOptions").add("Origin", originAsString()).add("ApplicationUrl", applicationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "ApplicationUrl":
            return Optional.ofNullable(clazz.cast(applicationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Origin", ORIGIN_FIELD);
        map.put("ApplicationUrl", APPLICATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignInOptions, T> g) {
        return obj -> g.apply((SignInOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SignInOptions> {
        /**
         * <p>
         * This determines how IAM Identity Center navigates the user to the target application. It can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
         * <code>ApplicationUrl</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to
         * sign the customer directly into a SAML-based application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        This determines how IAM Identity Center navigates the user to the target application. It can be one of
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
         *        <code>ApplicationUrl</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication
         *        to sign the customer directly into a SAML-based application.
         *        </p>
         *        </li>
         * @see SignInOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignInOrigin
         */
        Builder origin(String origin);

        /**
         * <p>
         * This determines how IAM Identity Center navigates the user to the target application. It can be one of the
         * following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
         * <code>ApplicationUrl</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication to
         * sign the customer directly into a SAML-based application.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        This determines how IAM Identity Center navigates the user to the target application. It can be one of
         *        the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICATION</code>: IAM Identity Center redirects the customer to the configured
         *        <code>ApplicationUrl</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IDENTITY_CENTER</code>: IAM Identity Center uses SAML identity-provider initiated authentication
         *        to sign the customer directly into a SAML-based application.
         *        </p>
         *        </li>
         * @see SignInOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignInOrigin
         */
        Builder origin(SignInOrigin origin);

        /**
         * <p>
         * The URL that accepts authentication requests for an application. This is a required parameter if the
         * <code>Origin</code> parameter is <code>APPLICATION</code>.
         * </p>
         * 
         * @param applicationUrl
         *        The URL that accepts authentication requests for an application. This is a required parameter if the
         *        <code>Origin</code> parameter is <code>APPLICATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationUrl(String applicationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String origin;

        private String applicationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SignInOptions model) {
            origin(model.origin);
            applicationUrl(model.applicationUrl);
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(SignInOrigin origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getApplicationUrl() {
            return applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        @Override
        public SignInOptions build() {
            return new SignInOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
