/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a trusted token issuer and associates it with a set of authorized audiences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizedTokenIssuer implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizedTokenIssuer.Builder, AuthorizedTokenIssuer> {
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustedTokenIssuerArn").getter(getter(AuthorizedTokenIssuer::trustedTokenIssuerArn))
            .setter(setter(Builder::trustedTokenIssuerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build())
            .build();

    private static final SdkField<List<String>> AUTHORIZED_AUDIENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedAudiences")
            .getter(getter(AuthorizedTokenIssuer::authorizedAudiences))
            .setter(setter(Builder::authorizedAudiences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAudiences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRUSTED_TOKEN_ISSUER_ARN_FIELD, AUTHORIZED_AUDIENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trustedTokenIssuerArn;

    private final List<String> authorizedAudiences;

    private AuthorizedTokenIssuer(BuilderImpl builder) {
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.authorizedAudiences = builder.authorizedAudiences;
    }

    /**
     * <p>
     * The ARN of the trusted token issuer.
     * </p>
     * 
     * @return The ARN of the trusted token issuer.
     */
    public final String trustedTokenIssuerArn() {
        return trustedTokenIssuerArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedAudiences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedAudiences() {
        return authorizedAudiences != null && !(authorizedAudiences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array list of authorized audiences, or applications, that can consume the tokens generated by the associated
     * trusted token issuer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedAudiences} method.
     * </p>
     * 
     * @return An array list of authorized audiences, or applications, that can consume the tokens generated by the
     *         associated trusted token issuer.
     */
    public final List<String> authorizedAudiences() {
        return authorizedAudiences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedAudiences() ? authorizedAudiences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTokenIssuer)) {
            return false;
        }
        AuthorizedTokenIssuer other = (AuthorizedTokenIssuer) obj;
        return Objects.equals(trustedTokenIssuerArn(), other.trustedTokenIssuerArn())
                && hasAuthorizedAudiences() == other.hasAuthorizedAudiences()
                && Objects.equals(authorizedAudiences(), other.authorizedAudiences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizedTokenIssuer").add("TrustedTokenIssuerArn", trustedTokenIssuerArn())
                .add("AuthorizedAudiences", hasAuthorizedAudiences() ? authorizedAudiences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustedTokenIssuerArn":
            return Optional.ofNullable(clazz.cast(trustedTokenIssuerArn()));
        case "AuthorizedAudiences":
            return Optional.ofNullable(clazz.cast(authorizedAudiences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
        map.put("AuthorizedAudiences", AUTHORIZED_AUDIENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTokenIssuer, T> g) {
        return obj -> g.apply((AuthorizedTokenIssuer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizedTokenIssuer> {
        /**
         * <p>
         * The ARN of the trusted token issuer.
         * </p>
         * 
         * @param trustedTokenIssuerArn
         *        The ARN of the trusted token issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedTokenIssuerArn(String trustedTokenIssuerArn);

        /**
         * <p>
         * An array list of authorized audiences, or applications, that can consume the tokens generated by the
         * associated trusted token issuer.
         * </p>
         * 
         * @param authorizedAudiences
         *        An array list of authorized audiences, or applications, that can consume the tokens generated by the
         *        associated trusted token issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAudiences(Collection<String> authorizedAudiences);

        /**
         * <p>
         * An array list of authorized audiences, or applications, that can consume the tokens generated by the
         * associated trusted token issuer.
         * </p>
         * 
         * @param authorizedAudiences
         *        An array list of authorized audiences, or applications, that can consume the tokens generated by the
         *        associated trusted token issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedAudiences(String... authorizedAudiences);
    }

    static final class BuilderImpl implements Builder {
        private String trustedTokenIssuerArn;

        private List<String> authorizedAudiences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTokenIssuer model) {
            trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            authorizedAudiences(model.authorizedAudiences);
        }

        public final String getTrustedTokenIssuerArn() {
            return trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final Collection<String> getAuthorizedAudiences() {
            if (authorizedAudiences instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedAudiences;
        }

        public final void setAuthorizedAudiences(Collection<String> authorizedAudiences) {
            this.authorizedAudiences = TokenIssuerAudiencesCopier.copy(authorizedAudiences);
        }

        @Override
        public final Builder authorizedAudiences(Collection<String> authorizedAudiences) {
            this.authorizedAudiences = TokenIssuerAudiencesCopier.copy(authorizedAudiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedAudiences(String... authorizedAudiences) {
            authorizedAudiences(Arrays.asList(authorizedAudiences));
            return this;
        }

        @Override
        public AuthorizedTokenIssuer build() {
            return new AuthorizedTokenIssuer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
