/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ScopeTargetsCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutApplicationAccessScopeRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, PutApplicationAccessScopeRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(PutApplicationAccessScopeRequest.getter(PutApplicationAccessScopeRequest::scope)).setter(PutApplicationAccessScopeRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTargets").getter(PutApplicationAccessScopeRequest.getter(PutApplicationAccessScopeRequest::authorizedTargets)).setter(PutApplicationAccessScopeRequest.setter(Builder::authorizedTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(PutApplicationAccessScopeRequest.getter(PutApplicationAccessScopeRequest::applicationArn)).setter(PutApplicationAccessScopeRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, AUTHORIZED_TARGETS_FIELD, APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutApplicationAccessScopeRequest.memberNameToFieldInitializer();
    private final String scope;
    private final List<String> authorizedTargets;
    private final String applicationArn;

    private PutApplicationAccessScopeRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.authorizedTargets = builder.authorizedTargets;
        this.applicationArn = builder.applicationArn;
    }

    public final String scope() {
        return this.scope;
    }

    public final boolean hasAuthorizedTargets() {
        return this.authorizedTargets != null && !(this.authorizedTargets instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedTargets() {
        return this.authorizedTargets;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTargets() ? this.authorizedTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutApplicationAccessScopeRequest)) {
            return false;
        }
        PutApplicationAccessScopeRequest other = (PutApplicationAccessScopeRequest)((Object)obj);
        return Objects.equals(this.scope(), other.scope()) && this.hasAuthorizedTargets() == other.hasAuthorizedTargets() && Objects.equals(this.authorizedTargets(), other.authorizedTargets()) && Objects.equals(this.applicationArn(), other.applicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutApplicationAccessScopeRequest").add("Scope", (Object)this.scope()).add("AuthorizedTargets", this.hasAuthorizedTargets() ? this.authorizedTargets() : null).add("ApplicationArn", (Object)this.applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "AuthorizedTargets": {
                return Optional.ofNullable(clazz.cast(this.authorizedTargets()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Scope", SCOPE_FIELD);
        map.put("AuthorizedTargets", AUTHORIZED_TARGETS_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutApplicationAccessScopeRequest, T> g) {
        return obj -> g.apply((PutApplicationAccessScopeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String scope;
        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutApplicationAccessScopeRequest model) {
            super(model);
            this.scope(model.scope);
            this.authorizedTargets(model.authorizedTargets);
            this.applicationArn(model.applicationArn);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (this.authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String ... authorizedTargets) {
            this.authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutApplicationAccessScopeRequest build() {
            return new PutApplicationAccessScopeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutApplicationAccessScopeRequest> {
        public Builder scope(String var1);

        public Builder authorizedTargets(Collection<String> var1);

        public Builder authorizedTargets(String ... var1);

        public Builder applicationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

