/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceStatus {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    ACTIVE("ACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceStatus> VALUE_MAP;
    private final String value;

    private InstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceStatus> knownValues() {
        EnumSet<InstanceStatus> knownValues = EnumSet.allOf(InstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceStatus.class, InstanceStatus::toString);
    }
}

