/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;

public class ListAccountsForProvisionedPermissionSetIterable
implements SdkIterable<ListAccountsForProvisionedPermissionSetResponse> {
    private final SsoAdminClient client;
    private final ListAccountsForProvisionedPermissionSetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountsForProvisionedPermissionSetIterable(SsoAdminClient client, ListAccountsForProvisionedPermissionSetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountsForProvisionedPermissionSetResponseFetcher();
    }

    public Iterator<ListAccountsForProvisionedPermissionSetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> accountIds() {
        Function<ListAccountsForProvisionedPermissionSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountIds() != null) {
                return response.accountIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountsForProvisionedPermissionSetResponseFetcher
    implements SyncPageFetcher<ListAccountsForProvisionedPermissionSetResponse> {
        private ListAccountsForProvisionedPermissionSetResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsForProvisionedPermissionSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountsForProvisionedPermissionSetResponse nextPage(ListAccountsForProvisionedPermissionSetResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsForProvisionedPermissionSetIterable.this.client.listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetIterable.this.firstRequest);
            }
            return ListAccountsForProvisionedPermissionSetIterable.this.client.listAccountsForProvisionedPermissionSet((ListAccountsForProvisionedPermissionSetRequest)((Object)ListAccountsForProvisionedPermissionSetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

