/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignment;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationAssignmentsListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationAssignmentsResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListApplicationAssignmentsResponse> {
    private static final SdkField<List<ApplicationAssignment>> APPLICATION_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationAssignments").getter(ListApplicationAssignmentsResponse.getter(ListApplicationAssignmentsResponse::applicationAssignments)).setter(ListApplicationAssignmentsResponse.setter(Builder::applicationAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationAssignmentsResponse.getter(ListApplicationAssignmentsResponse::nextToken)).setter(ListApplicationAssignmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ASSIGNMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationAssignmentsResponse.memberNameToFieldInitializer();
    private final List<ApplicationAssignment> applicationAssignments;
    private final String nextToken;

    private ListApplicationAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationAssignments = builder.applicationAssignments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationAssignments() {
        return this.applicationAssignments != null && !(this.applicationAssignments instanceof SdkAutoConstructList);
    }

    public final List<ApplicationAssignment> applicationAssignments() {
        return this.applicationAssignments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationAssignments() ? this.applicationAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAssignmentsResponse)) {
            return false;
        }
        ListApplicationAssignmentsResponse other = (ListApplicationAssignmentsResponse)((Object)obj);
        return this.hasApplicationAssignments() == other.hasApplicationAssignments() && Objects.equals(this.applicationAssignments(), other.applicationAssignments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationAssignmentsResponse").add("ApplicationAssignments", this.hasApplicationAssignments() ? this.applicationAssignments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationAssignments": {
                return Optional.ofNullable(clazz.cast(this.applicationAssignments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationAssignments", APPLICATION_ASSIGNMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAssignmentsResponse, T> g) {
        return obj -> g.apply((ListApplicationAssignmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<ApplicationAssignment> applicationAssignments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAssignmentsResponse model) {
            super(model);
            this.applicationAssignments(model.applicationAssignments);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationAssignment.Builder> getApplicationAssignments() {
            List<ApplicationAssignment.Builder> result = ApplicationAssignmentsListCopier.copyToBuilder(this.applicationAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationAssignments(Collection<ApplicationAssignment.BuilderImpl> applicationAssignments) {
            this.applicationAssignments = ApplicationAssignmentsListCopier.copyFromBuilder(applicationAssignments);
        }

        @Override
        public final Builder applicationAssignments(Collection<ApplicationAssignment> applicationAssignments) {
            this.applicationAssignments = ApplicationAssignmentsListCopier.copy(applicationAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAssignments(ApplicationAssignment ... applicationAssignments) {
            this.applicationAssignments(Arrays.asList(applicationAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAssignments(Consumer<ApplicationAssignment.Builder> ... applicationAssignments) {
            this.applicationAssignments(Stream.of(applicationAssignments).map(c -> (ApplicationAssignment)((ApplicationAssignment.Builder)ApplicationAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationAssignmentsResponse build() {
            return new ListApplicationAssignmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationAssignmentsResponse> {
        public Builder applicationAssignments(Collection<ApplicationAssignment> var1);

        public Builder applicationAssignments(ApplicationAssignment ... var1);

        public Builder applicationAssignments(Consumer<ApplicationAssignment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

