/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuer;
import software.amazon.awssdk.services.ssoadmin.model.AuthorizedTokenIssuersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JwtBearerGrant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JwtBearerGrant> {
    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTokenIssuers").getter(JwtBearerGrant.getter(JwtBearerGrant::authorizedTokenIssuers)).setter(JwtBearerGrant.setter(Builder::authorizedTokenIssuers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedTokenIssuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_TOKEN_ISSUERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AuthorizedTokenIssuer> authorizedTokenIssuers;

    private JwtBearerGrant(BuilderImpl builder) {
        this.authorizedTokenIssuers = builder.authorizedTokenIssuers;
    }

    public final boolean hasAuthorizedTokenIssuers() {
        return this.authorizedTokenIssuers != null && !(this.authorizedTokenIssuers instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedTokenIssuer> authorizedTokenIssuers() {
        return this.authorizedTokenIssuers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTokenIssuers() ? this.authorizedTokenIssuers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtBearerGrant)) {
            return false;
        }
        JwtBearerGrant other = (JwtBearerGrant)obj;
        return this.hasAuthorizedTokenIssuers() == other.hasAuthorizedTokenIssuers() && Objects.equals(this.authorizedTokenIssuers(), other.authorizedTokenIssuers());
    }

    public final String toString() {
        return ToString.builder((String)"JwtBearerGrant").add("AuthorizedTokenIssuers", this.hasAuthorizedTokenIssuers() ? this.authorizedTokenIssuers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedTokenIssuers": {
                return Optional.ofNullable(clazz.cast(this.authorizedTokenIssuers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JwtBearerGrant, T> g) {
        return obj -> g.apply((JwtBearerGrant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AuthorizedTokenIssuer> authorizedTokenIssuers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JwtBearerGrant model) {
            this.authorizedTokenIssuers(model.authorizedTokenIssuers);
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuers() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuersCopier.copyToBuilder(this.authorizedTokenIssuers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuers(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuers) {
            this.authorizedTokenIssuers = AuthorizedTokenIssuersCopier.copyFromBuilder(authorizedTokenIssuers);
        }

        @Override
        public final Builder authorizedTokenIssuers(Collection<AuthorizedTokenIssuer> authorizedTokenIssuers) {
            this.authorizedTokenIssuers = AuthorizedTokenIssuersCopier.copy(authorizedTokenIssuers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuers(AuthorizedTokenIssuer ... authorizedTokenIssuers) {
            this.authorizedTokenIssuers(Arrays.asList(authorizedTokenIssuers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuers(Consumer<AuthorizedTokenIssuer.Builder> ... authorizedTokenIssuers) {
            this.authorizedTokenIssuers(Stream.of(authorizedTokenIssuers).map(c -> (AuthorizedTokenIssuer)((AuthorizedTokenIssuer.Builder)AuthorizedTokenIssuer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public JwtBearerGrant build() {
            return new JwtBearerGrant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JwtBearerGrant> {
        public Builder authorizedTokenIssuers(Collection<AuthorizedTokenIssuer> var1);

        public Builder authorizedTokenIssuers(AuthorizedTokenIssuer ... var1);

        public Builder authorizedTokenIssuers(Consumer<AuthorizedTokenIssuer.Builder> ... var1);
    }
}

