/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.GrantType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationGrantRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DeleteApplicationGrantRequest> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(DeleteApplicationGrantRequest.getter(DeleteApplicationGrantRequest::applicationArn)).setter(DeleteApplicationGrantRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantType").getter(DeleteApplicationGrantRequest.getter(DeleteApplicationGrantRequest::grantTypeAsString)).setter(DeleteApplicationGrantRequest.setter(Builder::grantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, GRANT_TYPE_FIELD));
    private final String applicationArn;
    private final String grantType;

    private DeleteApplicationGrantRequest(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.grantType = builder.grantType;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final GrantType grantType() {
        return GrantType.fromValue(this.grantType);
    }

    public final String grantTypeAsString() {
        return this.grantType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationGrantRequest)) {
            return false;
        }
        DeleteApplicationGrantRequest other = (DeleteApplicationGrantRequest)((Object)obj);
        return Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.grantTypeAsString(), other.grantTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteApplicationGrantRequest").add("ApplicationArn", (Object)this.applicationArn()).add("GrantType", (Object)this.grantTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "GrantType": {
                return Optional.ofNullable(clazz.cast(this.grantTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationGrantRequest, T> g) {
        return obj -> g.apply((DeleteApplicationGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String applicationArn;
        private String grantType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationGrantRequest model) {
            super(model);
            this.applicationArn(model.applicationArn);
            this.grantType(model.grantType);
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        @Override
        public final Builder grantType(GrantType grantType) {
            this.grantType(grantType == null ? null : grantType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationGrantRequest build() {
            return new DeleteApplicationGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationGrantRequest> {
        public Builder applicationArn(String var1);

        public Builder grantType(String var1);

        public Builder grantType(GrantType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

