/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssoadmin.DefaultSsoAdminBaseClientBuilder;
import software.amazon.awssdk.services.ssoadmin.DefaultSsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClientBuilder;
import software.amazon.awssdk.services.ssoadmin.SsoAdminServiceClientConfiguration;
import software.amazon.awssdk.services.ssoadmin.endpoints.SsoAdminEndpointProvider;

@SdkInternalApi
final class DefaultSsoAdminClientBuilder
extends DefaultSsoAdminBaseClientBuilder<SsoAdminClientBuilder, SsoAdminClient>
implements SsoAdminClientBuilder {
    DefaultSsoAdminClientBuilder() {
    }

    @Override
    public DefaultSsoAdminClientBuilder endpointProvider(SsoAdminEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsoAdminClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsoAdminClientBuilder.validateClientOptions(clientConfiguration);
        SsoAdminServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsoAdminClient client = new DefaultSsoAdminClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsoAdminServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsoAdminServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

