/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignment;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;

public class ListAccountAssignmentsPublisher
implements SdkPublisher<ListAccountAssignmentsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListAccountAssignmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountAssignmentsPublisher(SsoAdminAsyncClient client, ListAccountAssignmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountAssignmentsPublisher(SsoAdminAsyncClient client, ListAccountAssignmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountAssignmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountAssignmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountAssignment> accountAssignments() {
        Function<ListAccountAssignmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignments() != null) {
                return response.accountAssignments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountAssignmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountAssignmentsResponseFetcher
    implements AsyncPageFetcher<ListAccountAssignmentsResponse> {
        private ListAccountAssignmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssignmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountAssignmentsResponse> nextPage(ListAccountAssignmentsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentsPublisher.this.client.listAccountAssignments(ListAccountAssignmentsPublisher.this.firstRequest);
            }
            return ListAccountAssignmentsPublisher.this.client.listAccountAssignments((ListAccountAssignmentsRequest)((Object)ListAccountAssignmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

