/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;

public class ListAccountAssignmentCreationStatusIterable
implements SdkIterable<ListAccountAssignmentCreationStatusResponse> {
    private final SsoAdminClient client;
    private final ListAccountAssignmentCreationStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAssignmentCreationStatusIterable(SsoAdminClient client, ListAccountAssignmentCreationStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAccountAssignmentCreationStatusResponseFetcher();
    }

    public Iterator<ListAccountAssignmentCreationStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAssignmentOperationStatusMetadata> accountAssignmentsCreationStatus() {
        Function<ListAccountAssignmentCreationStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.accountAssignmentsCreationStatus() != null) {
                return response.accountAssignmentsCreationStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAssignmentCreationStatusResponseFetcher
    implements SyncPageFetcher<ListAccountAssignmentCreationStatusResponse> {
        private ListAccountAssignmentCreationStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssignmentCreationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountAssignmentCreationStatusResponse nextPage(ListAccountAssignmentCreationStatusResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssignmentCreationStatusIterable.this.client.listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusIterable.this.firstRequest);
            }
            return ListAccountAssignmentCreationStatusIterable.this.client.listAccountAssignmentCreationStatus((ListAccountAssignmentCreationStatusRequest)((Object)ListAccountAssignmentCreationStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

