/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAssignmentCreationStatusRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DescribeAccountAssignmentCreationStatusRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DescribeAccountAssignmentCreationStatusRequest.getter(DescribeAccountAssignmentCreationStatusRequest::instanceArn)).setter(DescribeAccountAssignmentCreationStatusRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ASSIGNMENT_CREATION_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssignmentCreationRequestId").getter(DescribeAccountAssignmentCreationStatusRequest.getter(DescribeAccountAssignmentCreationStatusRequest::accountAssignmentCreationRequestId)).setter(DescribeAccountAssignmentCreationStatusRequest.setter(Builder::accountAssignmentCreationRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssignmentCreationRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, ACCOUNT_ASSIGNMENT_CREATION_REQUEST_ID_FIELD));
    private final String instanceArn;
    private final String accountAssignmentCreationRequestId;

    private DescribeAccountAssignmentCreationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.accountAssignmentCreationRequestId = builder.accountAssignmentCreationRequestId;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public String accountAssignmentCreationRequestId() {
        return this.accountAssignmentCreationRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssignmentCreationRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAssignmentCreationStatusRequest)) {
            return false;
        }
        DescribeAccountAssignmentCreationStatusRequest other = (DescribeAccountAssignmentCreationStatusRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.accountAssignmentCreationRequestId(), other.accountAssignmentCreationRequestId());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountAssignmentCreationStatusRequest").add("InstanceArn", (Object)this.instanceArn()).add("AccountAssignmentCreationRequestId", (Object)this.accountAssignmentCreationRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "AccountAssignmentCreationRequestId": {
                return Optional.ofNullable(clazz.cast(this.accountAssignmentCreationRequestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAssignmentCreationStatusRequest, T> g) {
        return obj -> g.apply((DescribeAccountAssignmentCreationStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String accountAssignmentCreationRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAssignmentCreationStatusRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.accountAssignmentCreationRequestId(model.accountAssignmentCreationRequestId);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getAccountAssignmentCreationRequestId() {
            return this.accountAssignmentCreationRequestId;
        }

        @Override
        public final Builder accountAssignmentCreationRequestId(String accountAssignmentCreationRequestId) {
            this.accountAssignmentCreationRequestId = accountAssignmentCreationRequestId;
            return this;
        }

        public final void setAccountAssignmentCreationRequestId(String accountAssignmentCreationRequestId) {
            this.accountAssignmentCreationRequestId = accountAssignmentCreationRequestId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountAssignmentCreationStatusRequest build() {
            return new DescribeAccountAssignmentCreationStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountAssignmentCreationStatusRequest> {
        public Builder instanceArn(String var1);

        public Builder accountAssignmentCreationRequestId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

