/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionSetsProvisionedToAccountRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPermissionSetsProvisionedToAccountRequest.getter(ListPermissionSetsProvisionedToAccountRequest::instanceArn)).setter(ListPermissionSetsProvisionedToAccountRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPermissionSetsProvisionedToAccountRequest.getter(ListPermissionSetsProvisionedToAccountRequest::accountId)).setter(ListPermissionSetsProvisionedToAccountRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPermissionSetsProvisionedToAccountRequest.getter(ListPermissionSetsProvisionedToAccountRequest::provisioningStatusAsString)).setter(ListPermissionSetsProvisionedToAccountRequest.setter(Builder::provisioningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListPermissionSetsProvisionedToAccountRequest.getter(ListPermissionSetsProvisionedToAccountRequest::maxResults)).setter(ListPermissionSetsProvisionedToAccountRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPermissionSetsProvisionedToAccountRequest.getter(ListPermissionSetsProvisionedToAccountRequest::nextToken)).setter(ListPermissionSetsProvisionedToAccountRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, ACCOUNT_ID_FIELD, PROVISIONING_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String instanceArn;
    private final String accountId;
    private final String provisioningStatus;
    private final Integer maxResults;
    private final String nextToken;

    private ListPermissionSetsProvisionedToAccountRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.accountId = builder.accountId;
        this.provisioningStatus = builder.provisioningStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public String accountId() {
        return this.accountId;
    }

    public ProvisioningStatus provisioningStatus() {
        return ProvisioningStatus.fromValue(this.provisioningStatus);
    }

    public String provisioningStatusAsString() {
        return this.provisioningStatus;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionSetsProvisionedToAccountRequest)) {
            return false;
        }
        ListPermissionSetsProvisionedToAccountRequest other = (ListPermissionSetsProvisionedToAccountRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.provisioningStatusAsString(), other.provisioningStatusAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPermissionSetsProvisionedToAccountRequest").add("InstanceArn", (Object)this.instanceArn()).add("AccountId", (Object)this.accountId()).add("ProvisioningStatus", (Object)this.provisioningStatusAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ProvisioningStatus": {
                return Optional.ofNullable(clazz.cast(this.provisioningStatusAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionSetsProvisionedToAccountRequest, T> g) {
        return obj -> g.apply((ListPermissionSetsProvisionedToAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String accountId;
        private String provisioningStatus;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionSetsProvisionedToAccountRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.accountId(model.accountId);
            this.provisioningStatus(model.provisioningStatus);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getProvisioningStatus() {
            return this.provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(ProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionSetsProvisionedToAccountRequest build() {
            return new ListPermissionSetsProvisionedToAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionSetsProvisionedToAccountRequest> {
        public Builder instanceArn(String var1);

        public Builder accountId(String var1);

        public Builder provisioningStatus(String var1);

        public Builder provisioningStatus(ProvisioningStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

