/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.AccountListCopier;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountsForProvisionedPermissionSetResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, ListAccountsForProvisionedPermissionSetResponse> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAccountsForProvisionedPermissionSetResponse.getter(ListAccountsForProvisionedPermissionSetResponse::accountIds)).setter(ListAccountsForProvisionedPermissionSetResponse.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAccountsForProvisionedPermissionSetResponse.getter(ListAccountsForProvisionedPermissionSetResponse::nextToken)).setter(ListAccountsForProvisionedPermissionSetResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> accountIds;
    private final String nextToken;

    private ListAccountsForProvisionedPermissionSetResponse(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.nextToken = builder.nextToken;
    }

    public boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountsForProvisionedPermissionSetResponse)) {
            return false;
        }
        ListAccountsForProvisionedPermissionSetResponse other = (ListAccountsForProvisionedPermissionSetResponse)((Object)obj);
        return Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAccountsForProvisionedPermissionSetResponse").add("AccountIds", this.accountIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountsForProvisionedPermissionSetResponse, T> g) {
        return obj -> g.apply((ListAccountsForProvisionedPermissionSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountsForProvisionedPermissionSetResponse model) {
            super(model);
            this.accountIds(model.accountIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountListCopier.copy(accountIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccountsForProvisionedPermissionSetResponse build() {
            return new ListAccountsForProvisionedPermissionSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountsForProvisionedPermissionSetResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

