/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.internal;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.util.json.JacksonUtils;
import software.amazon.awssdk.services.sso.auth.ExpiredTokenException;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public final class SsoAccessTokenProvider {
    private Path cachedTokenFilePath;

    public SsoAccessTokenProvider(Path cachedTokenFilePath) {
        this.cachedTokenFilePath = cachedTokenFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveAccessToken() {
        try (InputStream cachedTokenStream = Files.newInputStream(this.cachedTokenFilePath, new OpenOption[0]);){
            String string = this.getTokenFromJson(IoUtils.toUtf8String((InputStream)cachedTokenStream));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getTokenFromJson(String json) {
        JsonNode jsonNode = JacksonUtils.sensitiveJsonNodeOf((String)json);
        if (this.validateToken(jsonNode.get("expiresAt").asText())) {
            throw ExpiredTokenException.builder().message("The SSO session associated with this profile has expired or is otherwise invalid. To refresh this SSO session run aws sso login with the corresponding profile.").build();
        }
        return jsonNode.get("accessToken").asText();
    }

    private boolean validateToken(String expirationTime) {
        return Instant.now().isAfter(Instant.parse(expirationTime).minus(15L, ChronoUnit.MINUTES));
    }
}

