/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatabaseRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, GetDatabaseRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(GetDatabaseRequest.getter(GetDatabaseRequest::applicationId)).setter(GetDatabaseRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(GetDatabaseRequest.getter(GetDatabaseRequest::componentId)).setter(GetDatabaseRequest.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseId").getter(GetDatabaseRequest.getter(GetDatabaseRequest::databaseId)).setter(GetDatabaseRequest.setter(Builder::databaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseArn").getter(GetDatabaseRequest.getter(GetDatabaseRequest::databaseArn)).setter(GetDatabaseRequest.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, COMPONENT_ID_FIELD, DATABASE_ID_FIELD, DATABASE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDatabaseRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String componentId;
    private final String databaseId;
    private final String databaseArn;

    private GetDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.componentId = builder.componentId;
        this.databaseId = builder.databaseId;
        this.databaseArn = builder.databaseArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final String databaseId() {
        return this.databaseId;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatabaseRequest)) {
            return false;
        }
        GetDatabaseRequest other = (GetDatabaseRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.databaseId(), other.databaseId()) && Objects.equals(this.databaseArn(), other.databaseArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetDatabaseRequest").add("ApplicationId", (Object)this.applicationId()).add("ComponentId", (Object)this.componentId()).add("DatabaseId", (Object)this.databaseId()).add("DatabaseArn", (Object)this.databaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "DatabaseId": {
                return Optional.ofNullable(clazz.cast(this.databaseId()));
            }
            case "DatabaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("ComponentId", COMPONENT_ID_FIELD);
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("DatabaseArn", DATABASE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDatabaseRequest, T> g) {
        return obj -> g.apply((GetDatabaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String componentId;
        private String databaseId;
        private String databaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatabaseRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.componentId(model.componentId);
            this.databaseId(model.databaseId);
            this.databaseArn(model.databaseArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getDatabaseId() {
            return this.databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDatabaseRequest build() {
            return new GetDatabaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatabaseRequest> {
        public Builder applicationId(String var1);

        public Builder componentId(String var1);

        public Builder databaseId(String var1);

        public Builder databaseArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

