/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.DatabaseConnectionMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseConnection> {
    private static final SdkField<String> DATABASE_CONNECTION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseConnectionMethod").getter(DatabaseConnection.getter(DatabaseConnection::databaseConnectionMethodAsString)).setter(DatabaseConnection.setter(Builder::databaseConnectionMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConnectionMethod").build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseArn").getter(DatabaseConnection.getter(DatabaseConnection::databaseArn)).setter(DatabaseConnection.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()}).build();
    private static final SdkField<String> CONNECTION_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionIp").getter(DatabaseConnection.getter(DatabaseConnection::connectionIp)).setter(DatabaseConnection.setter(Builder::connectionIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_CONNECTION_METHOD_FIELD, DATABASE_ARN_FIELD, CONNECTION_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DatabaseConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseConnectionMethod;
    private final String databaseArn;
    private final String connectionIp;

    private DatabaseConnection(BuilderImpl builder) {
        this.databaseConnectionMethod = builder.databaseConnectionMethod;
        this.databaseArn = builder.databaseArn;
        this.connectionIp = builder.connectionIp;
    }

    public final DatabaseConnectionMethod databaseConnectionMethod() {
        return DatabaseConnectionMethod.fromValue(this.databaseConnectionMethod);
    }

    public final String databaseConnectionMethodAsString() {
        return this.databaseConnectionMethod;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    public final String connectionIp() {
        return this.connectionIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseConnectionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseConnection)) {
            return false;
        }
        DatabaseConnection other = (DatabaseConnection)obj;
        return Objects.equals(this.databaseConnectionMethodAsString(), other.databaseConnectionMethodAsString()) && Objects.equals(this.databaseArn(), other.databaseArn()) && Objects.equals(this.connectionIp(), other.connectionIp());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseConnection").add("DatabaseConnectionMethod", (Object)this.databaseConnectionMethodAsString()).add("DatabaseArn", (Object)this.databaseArn()).add("ConnectionIp", (Object)this.connectionIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseConnectionMethod": {
                return Optional.ofNullable(clazz.cast(this.databaseConnectionMethodAsString()));
            }
            case "DatabaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
            case "ConnectionIp": {
                return Optional.ofNullable(clazz.cast(this.connectionIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DatabaseConnectionMethod", DATABASE_CONNECTION_METHOD_FIELD);
        map.put("DatabaseArn", DATABASE_ARN_FIELD);
        map.put("ConnectionIp", CONNECTION_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseConnection, T> g) {
        return obj -> g.apply((DatabaseConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseConnectionMethod;
        private String databaseArn;
        private String connectionIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseConnection model) {
            this.databaseConnectionMethod(model.databaseConnectionMethod);
            this.databaseArn(model.databaseArn);
            this.connectionIp(model.connectionIp);
        }

        public final String getDatabaseConnectionMethod() {
            return this.databaseConnectionMethod;
        }

        public final void setDatabaseConnectionMethod(String databaseConnectionMethod) {
            this.databaseConnectionMethod = databaseConnectionMethod;
        }

        @Override
        public final Builder databaseConnectionMethod(String databaseConnectionMethod) {
            this.databaseConnectionMethod = databaseConnectionMethod;
            return this;
        }

        @Override
        public final Builder databaseConnectionMethod(DatabaseConnectionMethod databaseConnectionMethod) {
            this.databaseConnectionMethod(databaseConnectionMethod == null ? null : databaseConnectionMethod.toString());
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getConnectionIp() {
            return this.connectionIp;
        }

        public final void setConnectionIp(String connectionIp) {
            this.connectionIp = connectionIp;
        }

        @Override
        public final Builder connectionIp(String connectionIp) {
            this.connectionIp = connectionIp;
            return this;
        }

        public DatabaseConnection build() {
            return new DatabaseConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseConnection> {
        public Builder databaseConnectionMethod(String var1);

        public Builder databaseConnectionMethod(DatabaseConnectionMethod var1);

        public Builder databaseArn(String var1);

        public Builder connectionIp(String var1);
    }
}

