/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmsap.model.OperationPropertiesCopier;
import software.amazon.awssdk.services.ssmsap.model.OperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Operation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Operation.getter(Operation::id)).setter(Operation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Operation.getter(Operation::type)).setter(Operation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Operation.getter(Operation::statusAsString)).setter(Operation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Operation.getter(Operation::statusMessage)).setter(Operation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(Operation.getter(Operation::properties)).setter(Operation.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(Operation.getter(Operation::resourceType)).setter(Operation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(Operation.getter(Operation::resourceId)).setter(Operation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(Operation.getter(Operation::resourceArn)).setter(Operation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Operation.getter(Operation::startTime)).setter(Operation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Operation.getter(Operation::endTime)).setter(Operation.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Operation.getter(Operation::lastUpdatedTime)).setter(Operation.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PROPERTIES_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("Properties", PROPERTIES_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String status;
    private final String statusMessage;
    private final Map<String, String> properties;
    private final String resourceType;
    private final String resourceId;
    private final String resourceArn;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant lastUpdatedTime;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.properties = builder.properties;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String id() {
        return this.id;
    }

    public final String type() {
        return this.type;
    }

    public final OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"Operation").add("Id", (Object)this.id()).add("Type", (Object)this.type()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Properties", this.hasProperties() ? this.properties() : null).add("ResourceType", (Object)this.resourceType()).add("ResourceId", (Object)this.resourceId()).add("ResourceArn", (Object)this.resourceArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String status;
        private String statusMessage;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private String resourceType;
        private String resourceId;
        private String resourceArn;
        private Instant startTime;
        private Instant endTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.id(model.id);
            this.type(model.type);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.properties(model.properties);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
            this.resourceArn(model.resourceArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = OperationPropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = OperationPropertiesCopier.copy(properties);
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public Operation build() {
            return new Operation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder properties(Map<String, String> var1);

        public Builder resourceType(String var1);

        public Builder resourceId(String var1);

        public Builder resourceArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

