/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredential;
import software.amazon.awssdk.services.ssmsap.model.ApplicationCredentialListCopier;
import software.amazon.awssdk.services.ssmsap.model.ApplicationType;
import software.amazon.awssdk.services.ssmsap.model.InstanceListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapRequest;
import software.amazon.awssdk.services.ssmsap.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterApplicationRequest
extends SsmSapRequest
implements ToCopyableBuilder<Builder, RegisterApplicationRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::applicationId)).setter(RegisterApplicationRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationType").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::applicationTypeAsString)).setter(RegisterApplicationRequest.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationType").build()}).build();
    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::instances)).setter(RegisterApplicationRequest.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SAP_INSTANCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SapInstanceNumber").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::sapInstanceNumber)).setter(RegisterApplicationRequest.setter(Builder::sapInstanceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SapInstanceNumber").build()}).build();
    private static final SdkField<String> SID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sid").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::sid)).setter(RegisterApplicationRequest.setter(Builder::sid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sid").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::tags)).setter(RegisterApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ApplicationCredential>> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Credentials").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::credentials)).setter(RegisterApplicationRequest.setter(Builder::credentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationCredential::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseArn").getter(RegisterApplicationRequest.getter(RegisterApplicationRequest::databaseArn)).setter(RegisterApplicationRequest.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_TYPE_FIELD, INSTANCES_FIELD, SAP_INSTANCE_NUMBER_FIELD, SID_FIELD, TAGS_FIELD, CREDENTIALS_FIELD, DATABASE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationId", APPLICATION_ID_FIELD);
            this.put("ApplicationType", APPLICATION_TYPE_FIELD);
            this.put("Instances", INSTANCES_FIELD);
            this.put("SapInstanceNumber", SAP_INSTANCE_NUMBER_FIELD);
            this.put("Sid", SID_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Credentials", CREDENTIALS_FIELD);
            this.put("DatabaseArn", DATABASE_ARN_FIELD);
        }
    });
    private final String applicationId;
    private final String applicationType;
    private final List<String> instances;
    private final String sapInstanceNumber;
    private final String sid;
    private final Map<String, String> tags;
    private final List<ApplicationCredential> credentials;
    private final String databaseArn;

    private RegisterApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationType = builder.applicationType;
        this.instances = builder.instances;
        this.sapInstanceNumber = builder.sapInstanceNumber;
        this.sid = builder.sid;
        this.tags = builder.tags;
        this.credentials = builder.credentials;
        this.databaseArn = builder.databaseArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(this.applicationType);
    }

    public final String applicationTypeAsString() {
        return this.applicationType;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<String> instances() {
        return this.instances;
    }

    public final String sapInstanceNumber() {
        return this.sapInstanceNumber;
    }

    public final String sid() {
        return this.sid;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasCredentials() {
        return this.credentials != null && !(this.credentials instanceof SdkAutoConstructList);
    }

    public final List<ApplicationCredential> credentials() {
        return this.credentials;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sapInstanceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentials() ? this.credentials() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationRequest)) {
            return false;
        }
        RegisterApplicationRequest other = (RegisterApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationTypeAsString(), other.applicationTypeAsString()) && this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.sapInstanceNumber(), other.sapInstanceNumber()) && Objects.equals(this.sid(), other.sid()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasCredentials() == other.hasCredentials() && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.databaseArn(), other.databaseArn());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterApplicationRequest").add("ApplicationId", (Object)this.applicationId()).add("ApplicationType", (Object)this.applicationTypeAsString()).add("Instances", this.hasInstances() ? this.instances() : null).add("SapInstanceNumber", (Object)this.sapInstanceNumber()).add("Sid", (Object)this.sid()).add("Tags", this.hasTags() ? this.tags() : null).add("Credentials", this.hasCredentials() ? this.credentials() : null).add("DatabaseArn", (Object)this.databaseArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ApplicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationTypeAsString()));
            }
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "SapInstanceNumber": {
                return Optional.ofNullable(clazz.cast(this.sapInstanceNumber()));
            }
            case "Sid": {
                return Optional.ofNullable(clazz.cast(this.sid()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "DatabaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterApplicationRequest, T> g) {
        return obj -> g.apply((RegisterApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationType;
        private List<String> instances = DefaultSdkAutoConstructList.getInstance();
        private String sapInstanceNumber;
        private String sid;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<ApplicationCredential> credentials = DefaultSdkAutoConstructList.getInstance();
        private String databaseArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterApplicationRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.applicationType(model.applicationType);
            this.instances(model.instances);
            this.sapInstanceNumber(model.sapInstanceNumber);
            this.sid(model.sid);
            this.tags(model.tags);
            this.credentials(model.credentials);
            this.databaseArn(model.databaseArn);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final Collection<String> getInstances() {
            if (this.instances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instances;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceListCopier.copy(instances);
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final String getSapInstanceNumber() {
            return this.sapInstanceNumber;
        }

        public final void setSapInstanceNumber(String sapInstanceNumber) {
            this.sapInstanceNumber = sapInstanceNumber;
        }

        @Override
        public final Builder sapInstanceNumber(String sapInstanceNumber) {
            this.sapInstanceNumber = sapInstanceNumber;
            return this;
        }

        public final String getSid() {
            return this.sid;
        }

        public final void setSid(String sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<ApplicationCredential.Builder> getCredentials() {
            List<ApplicationCredential.Builder> result = ApplicationCredentialListCopier.copyToBuilder(this.credentials);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentials(Collection<ApplicationCredential.BuilderImpl> credentials) {
            this.credentials = ApplicationCredentialListCopier.copyFromBuilder(credentials);
        }

        @Override
        public final Builder credentials(Collection<ApplicationCredential> credentials) {
            this.credentials = ApplicationCredentialListCopier.copy(credentials);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(ApplicationCredential ... credentials) {
            this.credentials(Arrays.asList(credentials));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentials(Consumer<ApplicationCredential.Builder> ... credentials) {
            this.credentials(Stream.of(credentials).map(c -> (ApplicationCredential)((ApplicationCredential.Builder)ApplicationCredential.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterApplicationRequest build() {
            return new RegisterApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmSapRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterApplicationRequest> {
        public Builder applicationId(String var1);

        public Builder applicationType(String var1);

        public Builder applicationType(ApplicationType var1);

        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder sapInstanceNumber(String var1);

        public Builder sid(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder credentials(Collection<ApplicationCredential> var1);

        public Builder credentials(ApplicationCredential ... var1);

        public Builder credentials(Consumer<ApplicationCredential.Builder> ... var1);

        public Builder databaseArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

