/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListOperationEventsResponse;
import software.amazon.awssdk.services.ssmsap.model.OperationEvent;

public class ListOperationEventsIterable
implements SdkIterable<ListOperationEventsResponse> {
    private final SsmSapClient client;
    private final ListOperationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOperationEventsIterable(SsmSapClient client, ListOperationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOperationEventsResponseFetcher();
    }

    public Iterator<ListOperationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OperationEvent> operationEvents() {
        Function<ListOperationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.operationEvents() != null) {
                return response.operationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOperationEventsResponseFetcher
    implements SyncPageFetcher<ListOperationEventsResponse> {
        private ListOperationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListOperationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOperationEventsResponse nextPage(ListOperationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListOperationEventsIterable.this.client.listOperationEvents(ListOperationEventsIterable.this.firstRequest);
            }
            return ListOperationEventsIterable.this.client.listOperationEvents((ListOperationEventsRequest)((Object)ListOperationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

