/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ApplicationDiscoveryStatus;
import software.amazon.awssdk.services.ssmsap.model.ApplicationStatus;
import software.amazon.awssdk.services.ssmsap.model.ApplicationType;
import software.amazon.awssdk.services.ssmsap.model.ComponentIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Application
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Application> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Application.getter(Application::id)).setter(Application.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Application.getter(Application::typeAsString)).setter(Application.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Application.getter(Application::arn)).setter(Application.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> APP_REGISTRY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppRegistryArn").getter(Application.getter(Application::appRegistryArn)).setter(Application.setter(Builder::appRegistryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppRegistryArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Application.getter(Application::statusAsString)).setter(Application.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DISCOVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryStatus").getter(Application.getter(Application::discoveryStatusAsString)).setter(Application.setter(Builder::discoveryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryStatus").build()}).build();
    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Components").getter(Application.getter(Application::components)).setter(Application.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Application.getter(Application::lastUpdated)).setter(Application.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Application.getter(Application::statusMessage)).setter(Application.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ARN_FIELD, APP_REGISTRY_ARN_FIELD, STATUS_FIELD, DISCOVERY_STATUS_FIELD, COMPONENTS_FIELD, LAST_UPDATED_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String arn;
    private final String appRegistryArn;
    private final String status;
    private final String discoveryStatus;
    private final List<String> components;
    private final Instant lastUpdated;
    private final String statusMessage;

    private Application(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.arn = builder.arn;
        this.appRegistryArn = builder.appRegistryArn;
        this.status = builder.status;
        this.discoveryStatus = builder.discoveryStatus;
        this.components = builder.components;
        this.lastUpdated = builder.lastUpdated;
        this.statusMessage = builder.statusMessage;
    }

    public final String id() {
        return this.id;
    }

    public final ApplicationType type() {
        return ApplicationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final String appRegistryArn() {
        return this.appRegistryArn;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ApplicationDiscoveryStatus discoveryStatus() {
        return ApplicationDiscoveryStatus.fromValue(this.discoveryStatus);
    }

    public final String discoveryStatusAsString() {
        return this.discoveryStatus;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<String> components() {
        return this.components;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appRegistryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.appRegistryArn(), other.appRegistryArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.discoveryStatusAsString(), other.discoveryStatusAsString()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Application").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Arn", (Object)this.arn()).add("AppRegistryArn", (Object)this.appRegistryArn()).add("Status", (Object)this.statusAsString()).add("DiscoveryStatus", (Object)this.discoveryStatusAsString()).add("Components", this.hasComponents() ? this.components() : null).add("LastUpdated", (Object)this.lastUpdated()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AppRegistryArn": {
                return Optional.ofNullable(clazz.cast(this.appRegistryArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DiscoveryStatus": {
                return Optional.ofNullable(clazz.cast(this.discoveryStatusAsString()));
            }
            case "Components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String arn;
        private String appRegistryArn;
        private String status;
        private String discoveryStatus;
        private List<String> components = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdated;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            this.id(model.id);
            this.type(model.type);
            this.arn(model.arn);
            this.appRegistryArn(model.appRegistryArn);
            this.status(model.status);
            this.discoveryStatus(model.discoveryStatus);
            this.components(model.components);
            this.lastUpdated(model.lastUpdated);
            this.statusMessage(model.statusMessage);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ApplicationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAppRegistryArn() {
            return this.appRegistryArn;
        }

        public final void setAppRegistryArn(String appRegistryArn) {
            this.appRegistryArn = appRegistryArn;
        }

        @Override
        public final Builder appRegistryArn(String appRegistryArn) {
            this.appRegistryArn = appRegistryArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDiscoveryStatus() {
            return this.discoveryStatus;
        }

        public final void setDiscoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
        }

        @Override
        public final Builder discoveryStatus(String discoveryStatus) {
            this.discoveryStatus = discoveryStatus;
            return this;
        }

        @Override
        public final Builder discoveryStatus(ApplicationDiscoveryStatus discoveryStatus) {
            this.discoveryStatus(discoveryStatus == null ? null : discoveryStatus.toString());
            return this;
        }

        public final Collection<String> getComponents() {
            if (this.components instanceof SdkAutoConstructList) {
                return null;
            }
            return this.components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = ComponentIdListCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = ComponentIdListCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Application build() {
            return new Application(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Application> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ApplicationType var1);

        public Builder arn(String var1);

        public Builder appRegistryArn(String var1);

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);

        public Builder discoveryStatus(String var1);

        public Builder discoveryStatus(ApplicationDiscoveryStatus var1);

        public Builder components(Collection<String> var1);

        public Builder components(String ... var1);

        public Builder lastUpdated(Instant var1);

        public Builder statusMessage(String var1);
    }
}

