/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Host implements SdkPojo, Serializable, ToCopyableBuilder<Host.Builder, Host> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostName").getter(getter(Host::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()).build();

    private static final SdkField<String> HOST_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostRole").getter(getter(Host::hostRoleAsString)).setter(setter(Builder::hostRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostRole").build()).build();

    private static final SdkField<String> HOST_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HostIp")
            .getter(getter(Host::hostIp)).setter(setter(Builder::hostIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIp").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(Host::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD,
            HOST_ROLE_FIELD, HOST_IP_FIELD, INSTANCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostName;

    private final String hostRole;

    private final String hostIp;

    private final String instanceId;

    private Host(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hostRole = builder.hostRole;
        this.hostIp = builder.hostIp;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The name of the Dedicated Host.
     * </p>
     * 
     * @return The name of the Dedicated Host.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * The role of the Dedicated Host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRole} will
     * return {@link HostRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRoleAsString}.
     * </p>
     * 
     * @return The role of the Dedicated Host.
     * @see HostRole
     */
    public final HostRole hostRole() {
        return HostRole.fromValue(hostRole);
    }

    /**
     * <p>
     * The role of the Dedicated Host.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostRole} will
     * return {@link HostRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostRoleAsString}.
     * </p>
     * 
     * @return The role of the Dedicated Host.
     * @see HostRole
     */
    public final String hostRoleAsString() {
        return hostRole;
    }

    /**
     * <p>
     * The IP address of the Dedicated Host.
     * </p>
     * 
     * @return The IP address of the Dedicated Host.
     */
    public final String hostIp() {
        return hostIp;
    }

    /**
     * <p>
     * The instance ID of the instance on the Dedicated Host.
     * </p>
     * 
     * @return The instance ID of the instance on the Dedicated Host.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(hostRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostIp());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(hostRoleAsString(), other.hostRoleAsString())
                && Objects.equals(hostIp(), other.hostIp()) && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Host").add("HostName", hostName()).add("HostRole", hostRoleAsString()).add("HostIp", hostIp())
                .add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "HostRole":
            return Optional.ofNullable(clazz.cast(hostRoleAsString()));
        case "HostIp":
            return Optional.ofNullable(clazz.cast(hostIp()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * The name of the Dedicated Host.
         * </p>
         * 
         * @param hostName
         *        The name of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * The role of the Dedicated Host.
         * </p>
         * 
         * @param hostRole
         *        The role of the Dedicated Host.
         * @see HostRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRole
         */
        Builder hostRole(String hostRole);

        /**
         * <p>
         * The role of the Dedicated Host.
         * </p>
         * 
         * @param hostRole
         *        The role of the Dedicated Host.
         * @see HostRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostRole
         */
        Builder hostRole(HostRole hostRole);

        /**
         * <p>
         * The IP address of the Dedicated Host.
         * </p>
         * 
         * @param hostIp
         *        The IP address of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIp(String hostIp);

        /**
         * <p>
         * The instance ID of the instance on the Dedicated Host.
         * </p>
         * 
         * @param instanceId
         *        The instance ID of the instance on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String hostRole;

        private String hostIp;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            hostName(model.hostName);
            hostRole(model.hostRole);
            hostIp(model.hostIp);
            instanceId(model.instanceId);
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHostRole() {
            return hostRole;
        }

        public final void setHostRole(String hostRole) {
            this.hostRole = hostRole;
        }

        @Override
        public final Builder hostRole(String hostRole) {
            this.hostRole = hostRole;
            return this;
        }

        @Override
        public final Builder hostRole(HostRole hostRole) {
            this.hostRole(hostRole == null ? null : hostRole.toString());
            return this;
        }

        public final String getHostIp() {
            return hostIp;
        }

        public final void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        @Override
        public final Builder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        public Host build() {
            return new Host(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
