/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssmsap.DefaultSsmSapBaseClientBuilder;
import software.amazon.awssdk.services.ssmsap.DefaultSsmSapClient;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.SsmSapClientBuilder;
import software.amazon.awssdk.services.ssmsap.SsmSapServiceClientConfiguration;
import software.amazon.awssdk.services.ssmsap.endpoints.SsmSapEndpointProvider;

@SdkInternalApi
final class DefaultSsmSapClientBuilder
extends DefaultSsmSapBaseClientBuilder<SsmSapClientBuilder, SsmSapClient>
implements SsmSapClientBuilder {
    DefaultSsmSapClientBuilder() {
    }

    @Override
    public DefaultSsmSapClientBuilder endpointProvider(SsmSapEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmSapClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsmSapClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SsmSapServiceClientConfiguration serviceClientConfiguration = SsmSapServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSsmSapClient(serviceClientConfiguration, clientConfiguration);
    }
}

