/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.Application;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterApplicationResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, RegisterApplicationResponse> {
    private static final SdkField<Application> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Application").getter(RegisterApplicationResponse.getter(RegisterApplicationResponse::application)).setter(RegisterApplicationResponse.setter(Builder::application)).constructor(Application::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Application").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(RegisterApplicationResponse.getter(RegisterApplicationResponse::operationId)).setter(RegisterApplicationResponse.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, OPERATION_ID_FIELD));
    private final Application application;
    private final String operationId;

    private RegisterApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.operationId = builder.operationId;
    }

    public final Application application() {
        return this.application;
    }

    public final String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterApplicationResponse)) {
            return false;
        }
        RegisterApplicationResponse other = (RegisterApplicationResponse)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.operationId(), other.operationId());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterApplicationResponse").add("Application", (Object)this.application()).add("OperationId", (Object)this.operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterApplicationResponse, T> g) {
        return obj -> g.apply((RegisterApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private Application application;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterApplicationResponse model) {
            super(model);
            this.application(model.application);
            this.operationId(model.operationId);
        }

        public final Application.Builder getApplication() {
            return this.application != null ? this.application.toBuilder() : null;
        }

        public final void setApplication(Application.BuilderImpl application) {
            this.application = application != null ? application.build() : null;
        }

        @Override
        public final Builder application(Application application) {
            this.application = application;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public RegisterApplicationResponse build() {
            return new RegisterApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterApplicationResponse> {
        public Builder application(Application var1);

        default public Builder application(Consumer<Application.Builder> application) {
            return this.application((Application)((Application.Builder)Application.builder().applyMutation(application)).build());
        }

        public Builder operationId(String var1);
    }
}

