/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CredentialType {
    ADMIN("ADMIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CredentialType> VALUE_MAP;
    private final String value;

    private CredentialType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CredentialType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CredentialType> knownValues() {
        EnumSet<CredentialType> knownValues = EnumSet.allOf(CredentialType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CredentialType.class, CredentialType::toString);
    }
}

