/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ComponentStatus;
import software.amazon.awssdk.services.ssmsap.model.ComponentType;
import software.amazon.awssdk.services.ssmsap.model.DatabaseIdListCopier;
import software.amazon.awssdk.services.ssmsap.model.Host;
import software.amazon.awssdk.services.ssmsap.model.HostListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Component
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Component> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(Component.getter(Component::componentId)).setter(Component.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentId").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(Component.getter(Component::applicationId)).setter(Component.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentType").getter(Component.getter(Component::componentTypeAsString)).setter(Component.setter(Builder::componentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Component.getter(Component::statusAsString)).setter(Component.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Databases").getter(Component.getter(Component::databases)).setter(Component.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Host>> HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hosts").getter(Component.getter(Component::hosts)).setter(Component.setter(Builder::hosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Host::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryHost").getter(Component.getter(Component::primaryHost)).setter(Component.setter(Builder::primaryHost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryHost").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Component.getter(Component::lastUpdated)).setter(Component.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD, APPLICATION_ID_FIELD, COMPONENT_TYPE_FIELD, STATUS_FIELD, DATABASES_FIELD, HOSTS_FIELD, PRIMARY_HOST_FIELD, LAST_UPDATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentId;
    private final String applicationId;
    private final String componentType;
    private final String status;
    private final List<String> databases;
    private final List<Host> hosts;
    private final String primaryHost;
    private final Instant lastUpdated;

    private Component(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.applicationId = builder.applicationId;
        this.componentType = builder.componentType;
        this.status = builder.status;
        this.databases = builder.databases;
        this.hosts = builder.hosts;
        this.primaryHost = builder.primaryHost;
        this.lastUpdated = builder.lastUpdated;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final ComponentType componentType() {
        return ComponentType.fromValue(this.componentType);
    }

    public final String componentTypeAsString() {
        return this.componentType;
    }

    public final ComponentStatus status() {
        return ComponentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public final List<String> databases() {
        return this.databases;
    }

    public final boolean hasHosts() {
        return this.hosts != null && !(this.hosts instanceof SdkAutoConstructList);
    }

    public final List<Host> hosts() {
        return this.hosts;
    }

    public final String primaryHost() {
        return this.primaryHost;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabases() ? this.databases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHosts() ? this.hosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryHost());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Component)) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.componentTypeAsString(), other.componentTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasDatabases() == other.hasDatabases() && Objects.equals(this.databases(), other.databases()) && this.hasHosts() == other.hasHosts() && Objects.equals(this.hosts(), other.hosts()) && Objects.equals(this.primaryHost(), other.primaryHost()) && Objects.equals(this.lastUpdated(), other.lastUpdated());
    }

    public final String toString() {
        return ToString.builder((String)"Component").add("ComponentId", (Object)this.componentId()).add("ApplicationId", (Object)this.applicationId()).add("ComponentType", (Object)this.componentTypeAsString()).add("Status", (Object)this.statusAsString()).add("Databases", this.hasDatabases() ? this.databases() : null).add("Hosts", this.hasHosts() ? this.hosts() : null).add("PrimaryHost", (Object)this.primaryHost()).add("LastUpdated", (Object)this.lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "ComponentType": {
                return Optional.ofNullable(clazz.cast(this.componentTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "Hosts": {
                return Optional.ofNullable(clazz.cast(this.hosts()));
            }
            case "PrimaryHost": {
                return Optional.ofNullable(clazz.cast(this.primaryHost()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Component, T> g) {
        return obj -> g.apply((Component)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentId;
        private String applicationId;
        private String componentType;
        private String status;
        private List<String> databases = DefaultSdkAutoConstructList.getInstance();
        private List<Host> hosts = DefaultSdkAutoConstructList.getInstance();
        private String primaryHost;
        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(Component model) {
            this.componentId(model.componentId);
            this.applicationId(model.applicationId);
            this.componentType(model.componentType);
            this.status(model.status);
            this.databases(model.databases);
            this.hosts(model.hosts);
            this.primaryHost(model.primaryHost);
            this.lastUpdated(model.lastUpdated);
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getComponentType() {
            return this.componentType;
        }

        public final void setComponentType(String componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Builder componentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        @Override
        public final Builder componentType(ComponentType componentType) {
            this.componentType(componentType == null ? null : componentType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComponentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getDatabases() {
            if (this.databases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.databases;
        }

        public final void setDatabases(Collection<String> databases) {
            this.databases = DatabaseIdListCopier.copy(databases);
        }

        @Override
        public final Builder databases(Collection<String> databases) {
            this.databases = DatabaseIdListCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(String ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        public final List<Host.Builder> getHosts() {
            List<Host.Builder> result = HostListCopier.copyToBuilder(this.hosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHosts(Collection<Host.BuilderImpl> hosts) {
            this.hosts = HostListCopier.copyFromBuilder(hosts);
        }

        @Override
        public final Builder hosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Host ... hosts) {
            this.hosts(Arrays.asList(hosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Consumer<Host.Builder> ... hosts) {
            this.hosts(Stream.of(hosts).map(c -> (Host)((Host.Builder)Host.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrimaryHost() {
            return this.primaryHost;
        }

        public final void setPrimaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
        }

        @Override
        public final Builder primaryHost(String primaryHost) {
            this.primaryHost = primaryHost;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Component build() {
            return new Component(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Component> {
        public Builder componentId(String var1);

        public Builder applicationId(String var1);

        public Builder componentType(String var1);

        public Builder componentType(ComponentType var1);

        public Builder status(String var1);

        public Builder status(ComponentStatus var1);

        public Builder databases(Collection<String> var1);

        public Builder databases(String ... var1);

        public Builder hosts(Collection<Host> var1);

        public Builder hosts(Host ... var1);

        public Builder hosts(Consumer<Host.Builder> ... var1);

        public Builder primaryHost(String var1);

        public Builder lastUpdated(Instant var1);
    }
}

