/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationsListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationsResponse
extends SsmQuickSetupResponse
implements ToCopyableBuilder<Builder, ListConfigurationsResponse> {
    private static final SdkField<List<ConfigurationSummary>> CONFIGURATIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationsList").getter(ListConfigurationsResponse.getter(ListConfigurationsResponse::configurationsList)).setter(ListConfigurationsResponse.setter(Builder::configurationsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationsResponse.getter(ListConfigurationsResponse::nextToken)).setter(ListConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationsList", CONFIGURATIONS_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationSummary> configurationsList;
    private final String nextToken;

    private ListConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationsList = builder.configurationsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationsList() {
        return this.configurationsList != null && !(this.configurationsList instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationSummary> configurationsList() {
        return this.configurationsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationsList() ? this.configurationsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsResponse)) {
            return false;
        }
        ListConfigurationsResponse other = (ListConfigurationsResponse)((Object)obj);
        return this.hasConfigurationsList() == other.hasConfigurationsList() && Objects.equals(this.configurationsList(), other.configurationsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationsResponse").add("ConfigurationsList", this.hasConfigurationsList() ? this.configurationsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationsList": {
                return Optional.ofNullable(clazz.cast(this.configurationsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationsResponse, T> g) {
        return obj -> g.apply((ListConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationSummary> configurationsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsResponse model) {
            super(model);
            this.configurationsList(model.configurationsList);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationSummary.Builder> getConfigurationsList() {
            List<ConfigurationSummary.Builder> result = ConfigurationsListCopier.copyToBuilder(this.configurationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationsList(Collection<ConfigurationSummary.BuilderImpl> configurationsList) {
            this.configurationsList = ConfigurationsListCopier.copyFromBuilder(configurationsList);
        }

        @Override
        public final Builder configurationsList(Collection<ConfigurationSummary> configurationsList) {
            this.configurationsList = ConfigurationsListCopier.copy(configurationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationsList(ConfigurationSummary ... configurationsList) {
            this.configurationsList(Arrays.asList(configurationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationsList(Consumer<ConfigurationSummary.Builder> ... configurationsList) {
            this.configurationsList(Stream.of(configurationsList).map(c -> (ConfigurationSummary)((ConfigurationSummary.Builder)ConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationsResponse build() {
            return new ListConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmQuickSetupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationsResponse> {
        public Builder configurationsList(Collection<ConfigurationSummary> var1);

        public Builder configurationsList(ConfigurationSummary ... var1);

        public Builder configurationsList(Consumer<ConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

