/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.ChatbotSnsConfigurationSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.EmptyChatChannel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChatChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChatChannel> {
    private static final SdkField<List<String>> CHATBOT_SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("chatbotSns").getter(ChatChannel.getter(ChatChannel::chatbotSns)).setter(ChatChannel.setter(Builder::chatbotSns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatbotSns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EmptyChatChannel> EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("empty").getter(ChatChannel.getter(ChatChannel::empty)).setter(ChatChannel.setter(Builder::empty)).constructor(EmptyChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("empty").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHATBOT_SNS_FIELD, EMPTY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChatChannel.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> chatbotSns;
    private final EmptyChatChannel empty;
    private final Type type;

    private ChatChannel(BuilderImpl builder) {
        this.chatbotSns = builder.chatbotSns;
        this.empty = builder.empty;
        this.type = builder.type;
    }

    public final boolean hasChatbotSns() {
        return this.chatbotSns != null && !(this.chatbotSns instanceof SdkAutoConstructList);
    }

    public final List<String> chatbotSns() {
        return this.chatbotSns;
    }

    public final EmptyChatChannel empty() {
        return this.empty;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChatbotSns() ? this.chatbotSns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.empty());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatChannel)) {
            return false;
        }
        ChatChannel other = (ChatChannel)obj;
        return this.hasChatbotSns() == other.hasChatbotSns() && Objects.equals(this.chatbotSns(), other.chatbotSns()) && Objects.equals(this.empty(), other.empty());
    }

    public final String toString() {
        return ToString.builder((String)"ChatChannel").add("ChatbotSns", this.hasChatbotSns() ? this.chatbotSns() : null).add("Empty", (Object)this.empty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "chatbotSns": {
                return Optional.ofNullable(clazz.cast(this.chatbotSns()));
            }
            case "empty": {
                return Optional.ofNullable(clazz.cast(this.empty()));
            }
        }
        return Optional.empty();
    }

    public static ChatChannel fromChatbotSns(List<String> chatbotSns) {
        return (ChatChannel)ChatChannel.builder().chatbotSns(chatbotSns).build();
    }

    public static ChatChannel fromEmpty(EmptyChatChannel empty) {
        return (ChatChannel)ChatChannel.builder().empty(empty).build();
    }

    public static ChatChannel fromEmpty(Consumer<EmptyChatChannel.Builder> empty) {
        EmptyChatChannel.Builder builder = EmptyChatChannel.builder();
        empty.accept(builder);
        return ChatChannel.fromEmpty((EmptyChatChannel)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chatbotSns", CHATBOT_SNS_FIELD);
        map.put("empty", EMPTY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatChannel, T> g) {
        return obj -> g.apply((ChatChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CHATBOT_SNS,
        EMPTY,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> chatbotSns = DefaultSdkAutoConstructList.getInstance();
        private EmptyChatChannel empty;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChatChannel model) {
            this.chatbotSns(model.chatbotSns);
            this.empty(model.empty);
        }

        public final Collection<String> getChatbotSns() {
            if (this.chatbotSns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.chatbotSns;
        }

        public final void setChatbotSns(Collection<String> chatbotSns) {
            List<String> oldValue = this.chatbotSns;
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
            this.handleUnionValueChange(Type.CHATBOT_SNS, oldValue, this.chatbotSns);
        }

        @Override
        public final Builder chatbotSns(Collection<String> chatbotSns) {
            List<String> oldValue = this.chatbotSns;
            this.chatbotSns = ChatbotSnsConfigurationSetCopier.copy(chatbotSns);
            this.handleUnionValueChange(Type.CHATBOT_SNS, oldValue, this.chatbotSns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chatbotSns(String ... chatbotSns) {
            this.chatbotSns(Arrays.asList(chatbotSns));
            return this;
        }

        public final EmptyChatChannel.Builder getEmpty() {
            return this.empty != null ? this.empty.toBuilder() : null;
        }

        public final void setEmpty(EmptyChatChannel.BuilderImpl empty) {
            EmptyChatChannel oldValue = this.empty;
            this.empty = empty != null ? empty.build() : null;
            this.handleUnionValueChange(Type.EMPTY, oldValue, this.empty);
        }

        @Override
        public final Builder empty(EmptyChatChannel empty) {
            EmptyChatChannel oldValue = this.empty;
            this.empty = empty;
            this.handleUnionValueChange(Type.EMPTY, oldValue, this.empty);
            return this;
        }

        public ChatChannel build() {
            return new ChatChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChatChannel> {
        public Builder chatbotSns(Collection<String> var1);

        public Builder chatbotSns(String ... var1);

        public Builder empty(EmptyChatChannel var1);

        default public Builder empty(Consumer<EmptyChatChannel.Builder> empty) {
            return this.empty((EmptyChatChannel)((EmptyChatChannel.Builder)EmptyChatChannel.builder().applyMutation(empty)).build());
        }
    }
}

