/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.EventReference;
import software.amazon.awssdk.services.ssmincidents.model.EventReferenceListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTimelineEventRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, UpdateTimelineEventRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::clientToken)).setter(UpdateTimelineEventRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventData").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::eventData)).setter(UpdateTimelineEventRequest.setter(Builder::eventData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::eventId)).setter(UpdateTimelineEventRequest.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<List<EventReference>> EVENT_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventReferences").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::eventReferences)).setter(UpdateTimelineEventRequest.setter(Builder::eventReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::eventTime)).setter(UpdateTimelineEventRequest.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::eventType)).setter(UpdateTimelineEventRequest.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentRecordArn").getter(UpdateTimelineEventRequest.getter(UpdateTimelineEventRequest::incidentRecordArn)).setter(UpdateTimelineEventRequest.setter(Builder::incidentRecordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EVENT_DATA_FIELD, EVENT_ID_FIELD, EVENT_REFERENCES_FIELD, EVENT_TIME_FIELD, EVENT_TYPE_FIELD, INCIDENT_RECORD_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTimelineEventRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String eventData;
    private final String eventId;
    private final List<EventReference> eventReferences;
    private final Instant eventTime;
    private final String eventType;
    private final String incidentRecordArn;

    private UpdateTimelineEventRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.eventData = builder.eventData;
        this.eventId = builder.eventId;
        this.eventReferences = builder.eventReferences;
        this.eventTime = builder.eventTime;
        this.eventType = builder.eventType;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String eventData() {
        return this.eventData;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final boolean hasEventReferences() {
        return this.eventReferences != null && !(this.eventReferences instanceof SdkAutoConstructList);
    }

    public final List<EventReference> eventReferences() {
        return this.eventReferences;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final String incidentRecordArn() {
        return this.incidentRecordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventReferences() ? this.eventReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTimelineEventRequest)) {
            return false;
        }
        UpdateTimelineEventRequest other = (UpdateTimelineEventRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.eventData(), other.eventData()) && Objects.equals(this.eventId(), other.eventId()) && this.hasEventReferences() == other.hasEventReferences() && Objects.equals(this.eventReferences(), other.eventReferences()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.incidentRecordArn(), other.incidentRecordArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTimelineEventRequest").add("ClientToken", (Object)this.clientToken()).add("EventData", (Object)this.eventData()).add("EventId", (Object)this.eventId()).add("EventReferences", this.hasEventReferences() ? this.eventReferences() : null).add("EventTime", (Object)this.eventTime()).add("EventType", (Object)this.eventType()).add("IncidentRecordArn", (Object)this.incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "eventData": {
                return Optional.ofNullable(clazz.cast(this.eventData()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventReferences": {
                return Optional.ofNullable(clazz.cast(this.eventReferences()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "incidentRecordArn": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("eventData", EVENT_DATA_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventReferences", EVENT_REFERENCES_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("incidentRecordArn", INCIDENT_RECORD_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTimelineEventRequest, T> g) {
        return obj -> g.apply((UpdateTimelineEventRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String eventData;
        private String eventId;
        private List<EventReference> eventReferences = DefaultSdkAutoConstructList.getInstance();
        private Instant eventTime;
        private String eventType;
        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTimelineEventRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.eventData(model.eventData);
            this.eventId(model.eventId);
            this.eventReferences(model.eventReferences);
            this.eventTime(model.eventTime);
            this.eventType(model.eventType);
            this.incidentRecordArn(model.incidentRecordArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEventData() {
            return this.eventData;
        }

        public final void setEventData(String eventData) {
            this.eventData = eventData;
        }

        @Override
        public final Builder eventData(String eventData) {
            this.eventData = eventData;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final List<EventReference.Builder> getEventReferences() {
            List<EventReference.Builder> result = EventReferenceListCopier.copyToBuilder(this.eventReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventReferences(Collection<EventReference.BuilderImpl> eventReferences) {
            this.eventReferences = EventReferenceListCopier.copyFromBuilder(eventReferences);
        }

        @Override
        public final Builder eventReferences(Collection<EventReference> eventReferences) {
            this.eventReferences = EventReferenceListCopier.copy(eventReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventReferences(EventReference ... eventReferences) {
            this.eventReferences(Arrays.asList(eventReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventReferences(Consumer<EventReference.Builder> ... eventReferences) {
            this.eventReferences(Stream.of(eventReferences).map(c -> (EventReference)((EventReference.Builder)EventReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final String getIncidentRecordArn() {
            return this.incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTimelineEventRequest build() {
            return new UpdateTimelineEventRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTimelineEventRequest> {
        public Builder clientToken(String var1);

        public Builder eventData(String var1);

        public Builder eventId(String var1);

        public Builder eventReferences(Collection<EventReference> var1);

        public Builder eventReferences(EventReference ... var1);

        public Builder eventReferences(Consumer<EventReference.Builder> ... var1);

        public Builder eventTime(Instant var1);

        public Builder eventType(String var1);

        public Builder incidentRecordArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

