/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSummary;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSummaryListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIncidentRecordsResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, ListIncidentRecordsResponse> {
    private static final SdkField<List<IncidentRecordSummary>> INCIDENT_RECORD_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incidentRecordSummaries").getter(ListIncidentRecordsResponse.getter(ListIncidentRecordsResponse::incidentRecordSummaries)).setter(ListIncidentRecordsResponse.setter(Builder::incidentRecordSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncidentRecordSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIncidentRecordsResponse.getter(ListIncidentRecordsResponse::nextToken)).setter(ListIncidentRecordsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCIDENT_RECORD_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("incidentRecordSummaries", INCIDENT_RECORD_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<IncidentRecordSummary> incidentRecordSummaries;
    private final String nextToken;

    private ListIncidentRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.incidentRecordSummaries = builder.incidentRecordSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIncidentRecordSummaries() {
        return this.incidentRecordSummaries != null && !(this.incidentRecordSummaries instanceof SdkAutoConstructList);
    }

    public final List<IncidentRecordSummary> incidentRecordSummaries() {
        return this.incidentRecordSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentRecordSummaries() ? this.incidentRecordSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncidentRecordsResponse)) {
            return false;
        }
        ListIncidentRecordsResponse other = (ListIncidentRecordsResponse)((Object)obj);
        return this.hasIncidentRecordSummaries() == other.hasIncidentRecordSummaries() && Objects.equals(this.incidentRecordSummaries(), other.incidentRecordSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIncidentRecordsResponse").add("IncidentRecordSummaries", this.hasIncidentRecordSummaries() ? this.incidentRecordSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "incidentRecordSummaries": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListIncidentRecordsResponse, T> g) {
        return obj -> g.apply((ListIncidentRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private List<IncidentRecordSummary> incidentRecordSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncidentRecordsResponse model) {
            super(model);
            this.incidentRecordSummaries(model.incidentRecordSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<IncidentRecordSummary.Builder> getIncidentRecordSummaries() {
            List<IncidentRecordSummary.Builder> result = IncidentRecordSummaryListCopier.copyToBuilder(this.incidentRecordSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentRecordSummaries(Collection<IncidentRecordSummary.BuilderImpl> incidentRecordSummaries) {
            this.incidentRecordSummaries = IncidentRecordSummaryListCopier.copyFromBuilder(incidentRecordSummaries);
        }

        @Override
        public final Builder incidentRecordSummaries(Collection<IncidentRecordSummary> incidentRecordSummaries) {
            this.incidentRecordSummaries = IncidentRecordSummaryListCopier.copy(incidentRecordSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentRecordSummaries(IncidentRecordSummary ... incidentRecordSummaries) {
            this.incidentRecordSummaries(Arrays.asList(incidentRecordSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentRecordSummaries(Consumer<IncidentRecordSummary.Builder> ... incidentRecordSummaries) {
            this.incidentRecordSummaries(Stream.of(incidentRecordSummaries).map(c -> (IncidentRecordSummary)((IncidentRecordSummary.Builder)IncidentRecordSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIncidentRecordsResponse build() {
            return new ListIncidentRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIncidentRecordsResponse> {
        public Builder incidentRecordSummaries(Collection<IncidentRecordSummary> var1);

        public Builder incidentRecordSummaries(IncidentRecordSummary ... var1);

        public Builder incidentRecordSummaries(Consumer<IncidentRecordSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

