/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordSource;
import software.amazon.awssdk.services.ssmincidents.model.IncidentRecordStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncidentRecordSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncidentRecordSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(IncidentRecordSummary.getter(IncidentRecordSummary::arn)).setter(IncidentRecordSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(IncidentRecordSummary.getter(IncidentRecordSummary::creationTime)).setter(IncidentRecordSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Integer> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("impact").getter(IncidentRecordSummary.getter(IncidentRecordSummary::impact)).setter(IncidentRecordSummary.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()}).build();
    private static final SdkField<IncidentRecordSource> INCIDENT_RECORD_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incidentRecordSource").getter(IncidentRecordSummary.getter(IncidentRecordSummary::incidentRecordSource)).setter(IncidentRecordSummary.setter(Builder::incidentRecordSource)).constructor(IncidentRecordSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordSource").build()}).build();
    private static final SdkField<Instant> RESOLVED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("resolvedTime").getter(IncidentRecordSummary.getter(IncidentRecordSummary::resolvedTime)).setter(IncidentRecordSummary.setter(Builder::resolvedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(IncidentRecordSummary.getter(IncidentRecordSummary::statusAsString)).setter(IncidentRecordSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(IncidentRecordSummary.getter(IncidentRecordSummary::title)).setter(IncidentRecordSummary.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, IMPACT_FIELD, INCIDENT_RECORD_SOURCE_FIELD, RESOLVED_TIME_FIELD, STATUS_FIELD, TITLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("impact", IMPACT_FIELD);
            this.put("incidentRecordSource", INCIDENT_RECORD_SOURCE_FIELD);
            this.put("resolvedTime", RESOLVED_TIME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("title", TITLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant creationTime;
    private final Integer impact;
    private final IncidentRecordSource incidentRecordSource;
    private final Instant resolvedTime;
    private final String status;
    private final String title;

    private IncidentRecordSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.impact = builder.impact;
        this.incidentRecordSource = builder.incidentRecordSource;
        this.resolvedTime = builder.resolvedTime;
        this.status = builder.status;
        this.title = builder.title;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Integer impact() {
        return this.impact;
    }

    public final IncidentRecordSource incidentRecordSource() {
        return this.incidentRecordSource;
    }

    public final Instant resolvedTime() {
        return this.resolvedTime;
    }

    public final IncidentRecordStatus status() {
        return IncidentRecordStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String title() {
        return this.title;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentRecordSummary)) {
            return false;
        }
        IncidentRecordSummary other = (IncidentRecordSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.impact(), other.impact()) && Objects.equals(this.incidentRecordSource(), other.incidentRecordSource()) && Objects.equals(this.resolvedTime(), other.resolvedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.title(), other.title());
    }

    public final String toString() {
        return ToString.builder((String)"IncidentRecordSummary").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("Impact", (Object)this.impact()).add("IncidentRecordSource", (Object)this.incidentRecordSource()).add("ResolvedTime", (Object)this.resolvedTime()).add("Status", (Object)this.statusAsString()).add("Title", (Object)this.title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "incidentRecordSource": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordSource()));
            }
            case "resolvedTime": {
                return Optional.ofNullable(clazz.cast(this.resolvedTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IncidentRecordSummary, T> g) {
        return obj -> g.apply((IncidentRecordSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private Integer impact;
        private IncidentRecordSource incidentRecordSource;
        private Instant resolvedTime;
        private String status;
        private String title;

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentRecordSummary model) {
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.impact(model.impact);
            this.incidentRecordSource(model.incidentRecordSource);
            this.resolvedTime(model.resolvedTime);
            this.status(model.status);
            this.title(model.title);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getImpact() {
            return this.impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final IncidentRecordSource.Builder getIncidentRecordSource() {
            return this.incidentRecordSource != null ? this.incidentRecordSource.toBuilder() : null;
        }

        public final void setIncidentRecordSource(IncidentRecordSource.BuilderImpl incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource != null ? incidentRecordSource.build() : null;
        }

        @Override
        public final Builder incidentRecordSource(IncidentRecordSource incidentRecordSource) {
            this.incidentRecordSource = incidentRecordSource;
            return this;
        }

        public final Instant getResolvedTime() {
            return this.resolvedTime;
        }

        public final void setResolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
        }

        @Override
        public final Builder resolvedTime(Instant resolvedTime) {
            this.resolvedTime = resolvedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IncidentRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public IncidentRecordSummary build() {
            return new IncidentRecordSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncidentRecordSummary> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder impact(Integer var1);

        public Builder incidentRecordSource(IncidentRecordSource var1);

        default public Builder incidentRecordSource(Consumer<IncidentRecordSource.Builder> incidentRecordSource) {
            return this.incidentRecordSource((IncidentRecordSource)((IncidentRecordSource.Builder)IncidentRecordSource.builder().applyMutation(incidentRecordSource)).build());
        }

        public Builder resolvedTime(Instant var1);

        public Builder status(String var1);

        public Builder status(IncidentRecordStatus var1);

        public Builder title(String var1);
    }
}

