/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsError;
import software.amazon.awssdk.services.ssmincidents.model.BatchGetIncidentFindingsErrorListCopier;
import software.amazon.awssdk.services.ssmincidents.model.Finding;
import software.amazon.awssdk.services.ssmincidents.model.FindingListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetIncidentFindingsResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, BatchGetIncidentFindingsResponse> {
    private static final SdkField<List<BatchGetIncidentFindingsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetIncidentFindingsResponse.getter(BatchGetIncidentFindingsResponse::errors)).setter(BatchGetIncidentFindingsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetIncidentFindingsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Finding>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findings").getter(BatchGetIncidentFindingsResponse.getter(BatchGetIncidentFindingsResponse::findings)).setter(BatchGetIncidentFindingsResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Finding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errors", ERRORS_FIELD);
            this.put("findings", FINDINGS_FIELD);
        }
    });
    private final List<BatchGetIncidentFindingsError> errors;
    private final List<Finding> findings;

    private BatchGetIncidentFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.findings = builder.findings;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetIncidentFindingsError> errors() {
        return this.errors;
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<Finding> findings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetIncidentFindingsResponse)) {
            return false;
        }
        BatchGetIncidentFindingsResponse other = (BatchGetIncidentFindingsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasFindings() == other.hasFindings() && Objects.equals(this.findings(), other.findings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetIncidentFindingsResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("Findings", this.hasFindings() ? this.findings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetIncidentFindingsResponse, T> g) {
        return obj -> g.apply((BatchGetIncidentFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private List<BatchGetIncidentFindingsError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<Finding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetIncidentFindingsResponse model) {
            super(model);
            this.errors(model.errors);
            this.findings(model.findings);
        }

        public final List<BatchGetIncidentFindingsError.Builder> getErrors() {
            List<BatchGetIncidentFindingsError.Builder> result = BatchGetIncidentFindingsErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetIncidentFindingsError.BuilderImpl> errors) {
            this.errors = BatchGetIncidentFindingsErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetIncidentFindingsError> errors) {
            this.errors = BatchGetIncidentFindingsErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetIncidentFindingsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetIncidentFindingsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetIncidentFindingsError)((BatchGetIncidentFindingsError.Builder)BatchGetIncidentFindingsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Finding.Builder> getFindings() {
            List<Finding.Builder> result = FindingListCopier.copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<Finding.BuilderImpl> findings) {
            this.findings = FindingListCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<Finding> findings) {
            this.findings = FindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Finding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<Finding.Builder> ... findings) {
            this.findings(Stream.of(findings).map(c -> (Finding)((Finding.Builder)Finding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetIncidentFindingsResponse build() {
            return new BatchGetIncidentFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetIncidentFindingsResponse> {
        public Builder errors(Collection<BatchGetIncidentFindingsError> var1);

        public Builder errors(BatchGetIncidentFindingsError ... var1);

        public Builder errors(Consumer<BatchGetIncidentFindingsError.Builder> ... var1);

        public Builder findings(Collection<Finding> var1);

        public Builder findings(Finding ... var1);

        public Builder findings(Consumer<Finding.Builder> ... var1);
    }
}

