/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationStackUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationStackUpdate> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(CloudFormationStackUpdate.getter(CloudFormationStackUpdate::endTime)).setter(CloudFormationStackUpdate.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackArn").getter(CloudFormationStackUpdate.getter(CloudFormationStackUpdate::stackArn)).setter(CloudFormationStackUpdate.setter(Builder::stackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(CloudFormationStackUpdate.getter(CloudFormationStackUpdate::startTime)).setter(CloudFormationStackUpdate.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, STACK_ARN_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("endTime", END_TIME_FIELD);
            this.put("stackArn", STACK_ARN_FIELD);
            this.put("startTime", START_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant endTime;
    private final String stackArn;
    private final Instant startTime;

    private CloudFormationStackUpdate(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.stackArn = builder.stackArn;
        this.startTime = builder.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String stackArn() {
        return this.stackArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationStackUpdate)) {
            return false;
        }
        CloudFormationStackUpdate other = (CloudFormationStackUpdate)obj;
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.stackArn(), other.stackArn()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationStackUpdate").add("EndTime", (Object)this.endTime()).add("StackArn", (Object)this.stackArn()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "stackArn": {
                return Optional.ofNullable(clazz.cast(this.stackArn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationStackUpdate, T> g) {
        return obj -> g.apply((CloudFormationStackUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant endTime;
        private String stackArn;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationStackUpdate model) {
            this.endTime(model.endTime);
            this.stackArn(model.stackArn);
            this.startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStackArn() {
            return this.stackArn;
        }

        public final void setStackArn(String stackArn) {
            this.stackArn = stackArn;
        }

        @Override
        public final Builder stackArn(String stackArn) {
            this.stackArn = stackArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public CloudFormationStackUpdate build() {
            return new CloudFormationStackUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationStackUpdate> {
        public Builder endTime(Instant var1);

        public Builder stackArn(String var1);

        public Builder startTime(Instant var1);
    }
}

