/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.FindingIdListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetIncidentFindingsRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, BatchGetIncidentFindingsRequest> {
    private static final SdkField<List<String>> FINDING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingIds").getter(BatchGetIncidentFindingsRequest.getter(BatchGetIncidentFindingsRequest::findingIds)).setter(BatchGetIncidentFindingsRequest.setter(Builder::findingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentRecordArn").getter(BatchGetIncidentFindingsRequest.getter(BatchGetIncidentFindingsRequest::incidentRecordArn)).setter(BatchGetIncidentFindingsRequest.setter(Builder::incidentRecordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDS_FIELD, INCIDENT_RECORD_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("findingIds", FINDING_IDS_FIELD);
            this.put("incidentRecordArn", INCIDENT_RECORD_ARN_FIELD);
        }
    });
    private final List<String> findingIds;
    private final String incidentRecordArn;

    private BatchGetIncidentFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIds = builder.findingIds;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    public final boolean hasFindingIds() {
        return this.findingIds != null && !(this.findingIds instanceof SdkAutoConstructList);
    }

    public final List<String> findingIds() {
        return this.findingIds;
    }

    public final String incidentRecordArn() {
        return this.incidentRecordArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingIds() ? this.findingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetIncidentFindingsRequest)) {
            return false;
        }
        BatchGetIncidentFindingsRequest other = (BatchGetIncidentFindingsRequest)((Object)obj);
        return this.hasFindingIds() == other.hasFindingIds() && Objects.equals(this.findingIds(), other.findingIds()) && Objects.equals(this.incidentRecordArn(), other.incidentRecordArn());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetIncidentFindingsRequest").add("FindingIds", this.hasFindingIds() ? this.findingIds() : null).add("IncidentRecordArn", (Object)this.incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingIds": {
                return Optional.ofNullable(clazz.cast(this.findingIds()));
            }
            case "incidentRecordArn": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetIncidentFindingsRequest, T> g) {
        return obj -> g.apply((BatchGetIncidentFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private List<String> findingIds = DefaultSdkAutoConstructList.getInstance();
        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetIncidentFindingsRequest model) {
            super(model);
            this.findingIds(model.findingIds);
            this.incidentRecordArn(model.incidentRecordArn);
        }

        public final Collection<String> getFindingIds() {
            if (this.findingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingIds;
        }

        public final void setFindingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdListCopier.copy(findingIds);
        }

        @Override
        public final Builder findingIds(Collection<String> findingIds) {
            this.findingIds = FindingIdListCopier.copy(findingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIds(String ... findingIds) {
            this.findingIds(Arrays.asList(findingIds));
            return this;
        }

        public final String getIncidentRecordArn() {
            return this.incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetIncidentFindingsRequest build() {
            return new BatchGetIncidentFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetIncidentFindingsRequest> {
        public Builder findingIds(Collection<String> var1);

        public Builder findingIds(String ... var1);

        public Builder incidentRecordArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

